package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformApiMangeConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformMenusApiConvert;
import com.elitescloud.cloudt.system.cacheable.SysCacheMenuRpcService;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.model.entity.SysMenuOperationDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.*;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuBasicRespVO;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuOperationRespVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.platform.service.repo.*;
import com.elitescloud.cloudt.system.constant.SysMqConstant;
import com.elitescloud.cloudt.system.dto.mq.SysMenuDeleteMessage;
import com.elitescloud.cloudt.system.service.common.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Service
@Slf4j
@RequiredArgsConstructor
public class SysPlatformMenusServiceImpl implements SysPlatformMenusService {
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final SysPlatformMenusRepoProc sysPlatformMenusRepoProc;
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final SysPlatformMenusApiRepo sysPlatformMenusApiRepo;
    private final SysPlatformMenusApiRepoProc menusApiRepoProc;
    private final SysPlatformApiManageRepo sysPlatformApiManageRepo;
    private final SysPlatformApiManageRepoProc sysPlatformApiManageRepoProc;
    private final SysPlatformAdminMenusRepoProc adminMenusRepoProc;
    private final MenuOperationRepoProc menuOperationRepoProc;

    @Autowired
    private MessageQueueTemplate messageQueueTemplate;
    @Autowired
    private SysCacheMenuRpcService cacheMenuRpcService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addMenusGroup(AddMenusParam param) {

        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS_GROUP.name());
        return saveDo(saveDo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addMenus(AddMenusParam param) {
        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS.name());

        return saveDo(saveDo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addButton(AddButtonParam param) {
        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.BUTTON.name());
        //  saveDo.setMenusType(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
        return saveDo(saveDo);
    }

    private ApiResult<Long> saveDo(SysPlatformMenusDO saveDo) {
        var list = sysPlatformMenusRepo.findAllByMenusCode(saveDo.getMenusCode());
        if (!list.isEmpty()) {
            var obj = list.get(0);
            return ApiResult.fail("菜单编码重复：（重复应用：" + obj.getMenusAppCode() + "-菜单名称：" + obj.getMenusName() + "编码：" + obj.getMenusCode() + ")");
        }

        if (StringUtils.hasText(saveDo.getMenusParentCode())) {
            // 类型取上级菜单的类型，解决按钮时没有传递类型
            var parentMenu = sysPlatformMenusRepoProc.getByMenusCode(saveDo.getMenusParentCode());
            Assert.notNull(parentMenu, "上级菜单不存在");
            saveDo.setMenusType(parentMenu.getMenusType());
        }

        // 清空缓存
        clearCache();

        return ApiResult.ok(sysPlatformMenusRepo.save(saveDo).getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addFormMenus(AddFormMenusParam addMenusParam) {
        var saveDo = MenusConvert.INSTANCE.saveParamToDo(addMenusParam);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.FORM_MENUS.name());
        //  saveDo.setMenusType(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
        return saveDo(saveDo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateFormMenus(Long id, UpdateFormMenusParam updateMenusParam) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
//                    if (updateVerify(allowUpdate, sysPlatformAppDO, updateMenusParam.getMenusCode())) {
//                        return;
//                    }
//                    sysPlatformAppDO.setMenusAppCode(updateMenusParam.getMenusAppCode());
                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
//                    sysPlatformAppDO.setMenusCode(updateMenusParam.getMenusCode());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });

        // 清空缓存
        clearCache();
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum() {
        return ApiResult.ok(
                PlatformMenusOuterLinkTypeEnum.getUdcVOList()
//                List.of(
//                        PlatformMenusOuterLinkTypeEnum.URL.getUdcVO(),
//                        PlatformMenusOuterLinkTypeEnum.LCDP.getUdcVO(),
//                        PlatformMenusOuterLinkTypeEnum.LCBP.getUdcVO()
//                )
        );
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateMenusGroup(Long id, UpdateMenusParam updateMenusParam) {
        return updateMenus(id, updateMenusParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateMenus(Long id, UpdateMenusParam updateMenusParam) {
        //   AtomicReference<Boolean> allowUpdate = new AtomicReference<>(false);
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {

                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
                    sysPlatformAppDO.setMenusType(updateMenusParam.getMenusType());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformAppDO.setOuterLink(updateMenusParam.getOuterLink());
                    sysPlatformAppDO.setOuterLinkType(updateMenusParam.getOuterLinkType());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                    //     allowUpdate.set(true);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });

        // 清空缓存
        clearCache();
        return ApiResult.ok(true);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateButton(Long id, UpdateButtonParam updateMenusParam) {

        AtomicReference<Boolean> allowUpdate = new AtomicReference<>(false);
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
//                    if (updateVerify(allowUpdate, sysPlatformAppDO, updateMenusParam.getMenusCode())) {
//                        return;
//                    }
                    //  sysPlatformAppDO.setMenusAppCode(updateMenusParam.getMenusAppCode());
                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
                    //   sysPlatformAppDO.setMenusCode(updateMenusParam.getMenusCode());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                    allowUpdate.set(true);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });

        // 清空缓存
        clearCache();
        if (allowUpdate.get()) {
            return ApiResult.ok(true);
        } else {
            return ApiResult.fail("菜单编码已经存在,重复:");
        }
    }

    private boolean updateVerify(AtomicReference<Boolean> allowUpdate,
                                 SysPlatformMenusDO sysPlatformAppDO, String menusCode) {
        //如果更新code 修改的code 不等于老code 需要进行唯一校验 如果是老code直接更新
        if (!sysPlatformAppDO.getMenusCode().equals(menusCode)) {
            var list =
                    sysPlatformMenusRepo.findAllByMenusCode(menusCode);
            if (!list.isEmpty()) {
                allowUpdate.set(false);
                return true;
                // throw new BusinessException("Code已经存在重复:" + updateMenusParam.getAppCode());
            }
        }
        return false;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> deleteFlagMenus(Long id) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO ->
                {
                    sysPlatformMenusDO.setDeleteFlag(1);
                    sysPlatformMenusRepo.save(sysPlatformMenusDO);

                    messageQueueTemplate.publishMessage(Application.NAME, SysMqConstant.CHANNEL_MENU_DELETE, new SysMenuDeleteMessage(sysPlatformMenusDO.getMenusCode()));
                }
                ,
                () -> {
                    throw new BusinessException("id不存在");
                });

        // 清空缓存
        clearCache();

        return ApiResult.ok(true);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateMenusState(Long id, Boolean state) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO ->
                {
                    sysPlatformMenusDO.setMenusState(state);
                    sysPlatformMenusRepo.save(sysPlatformMenusDO);
                }
                ,
                () -> {
                    throw new BusinessException("id不存在");
                });

        // 清空缓存
        clearCache();

        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<SysPlatformMenusVO> getMenus(Long id) {
        var objDO = sysPlatformMenusRepo.findById(id);
        if (objDO.isPresent()) {
            return ApiResult.ok(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO(objDO.get()));
        } else {
            return ApiResult.fail("id不存在");
        }
    }

    @Override
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(QueryMenusParam queryMenusParam) {
        List<SysPlatformMenusDO> listDO;
        var qdo = QSysPlatformMenusDO.sysPlatformMenusDO;
//        Predicate predicate = Expressions.booleanTemplate("1=1");
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getAppCode()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusAppCode.eq(queryMenusParam.getAppCode()));
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getMenusName()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusName.eq(queryMenusParam.getMenusName()));
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getMenusCode()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusCode.eq(queryMenusParam.getMenusCode()));
//        predicate = queryMenusParam.getMenusType() == null ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusType.eq(queryMenusParam.getMenusType().name()));
//        predicate = queryMenusParam.getMenusState() == null ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusState.eq(queryMenusParam.getMenusState()));
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getNodeType()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.nodeType.eq(queryMenusParam.getNodeType()));

        Predicate predicate = JpaPredicateBuilder.builder()
                .and(qdo.menusAppCode::eq, queryMenusParam.getAppCode())
                .and(qdo.menusName::eq, queryMenusParam.getMenusName())
                .and(qdo.menusCode::eq, queryMenusParam.getMenusCode())
                .and(qdo.menusType::eq, queryMenusParam.getMenusType().name())
                .and(qdo.menusState::eq, queryMenusParam.getMenusState())
                .and(qdo.nodeType::eq, queryMenusParam.getNodeType())
                .getPredicate();

        List<SysPlatformMenusVO> listVO = new ArrayList<>();

        sysPlatformMenusRepo.findAll(predicate)
                .iterator().forEachRemaining(sysPlatformMenusDO -> {
                    listVO.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO(sysPlatformMenusDO));
                });
        return ApiResult.ok(listVO);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
//        List<SysUdcVO> sysUdcVOList = new ArrayList<>();
//        sysUdcVOList.add(PlatformConstantUtil.newSysUdcVO(PlatformEnum.PLATFORM_MENUS_TYPE_SYS));
//        sysUdcVOList.add(PlatformConstantUtil.newSysUdcVO(PlatformEnum.PLATFORM_MENUS_TYPE_BUS));
        return ApiResult.ok(
                List.of(
                        PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.getUdcVO(),
                        PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.getUdcVO()
                )

        );
    }

    @Override
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();

        getAppMenusVO.setSysPlatformAppVOS(
                sysPlatformAppRepo.findAll()
                        .stream()
                        .filter(sysPlatformAppDO -> sysPlatformAppDO.getAppState() && sysPlatformAppDO.getDeleteFlag() == 0)
                        .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                        .collect(Collectors.toList()));

        getAppMenusVO.setSysPlatformMenusVOS(
                sysPlatformMenusRepo.findAll()
                        .stream()
                        .filter(sysPlatformMenusDO -> sysPlatformMenusDO.getMenusState() && sysPlatformMenusDO.getDeleteFlag() == 0)
                        .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                        .collect(Collectors.toList())
        );
        return ApiResult.ok(getAppMenusVO);
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysAppMenusAll(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        Set<String> menusTypes = null;
        if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusTypes = Set.of(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name(), PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name());
        } else if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusTypes = Set.of(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name());
        }

        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(sysPlatformAppRepo.findByAppType(appType)
                    .stream()
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                            .filter(t -> Boolean.TRUE.equals(t.getAppState()))
                    .collect(Collectors.toList()));

        }
        if (menusTypes != null) {
            getAppMenusVO.setSysPlatformMenusVOS(
                    sysPlatformMenusRepoProc.listByMenusType(
                                    menusTypes).stream()
                            .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                            .filter(t -> Boolean.TRUE.equals(t.getMenusState()))
                            .collect(Collectors.toList())
            );
        }
        return ApiResult.ok(getAppMenusVO);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> deleteMenus(Long id) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(menusDO -> {
            int count = sysPlatformMenusRepo.findAllByMenusParentCode(menusDO.getMenusCode()).size();
            if (count != 0) {
                throw new BusinessException("请先删除子菜单。子菜单数量：" + count);
            } else {
                sysPlatformMenusRepo.deleteById(id);

                // 删除管理员菜单
                adminMenusRepoProc.deleteByMenuCode(menusDO.getMenusCode());
                // 删除菜单下的接口
                menusApiRepoProc.deleteByMenuCode(menusDO.getMenusCode());

                // 发布消息
                messageQueueTemplate.publishMessage(Application.NAME, SysMqConstant.CHANNEL_MENU_DELETE, new SysMenuDeleteMessage(menusDO.getMenusCode()));
            }

        }, () -> {
            throw new BusinessException("id不存在");
        });

        // 清空缓存
        clearCache();

        return ApiResult.ok();
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysBusAppMenus(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        Set<String> menusTypes = null;
        if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusTypes = Set.of(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name(), PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name());
        } else if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusTypes = Set.of(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name());
        }

        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(sysPlatformAppRepo.findByAppTypeAndAppState(appType, true)
                    .stream()
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                    .collect(Collectors.toList()));

        }
        if (menusTypes != null) {
            getAppMenusVO.setSysPlatformMenusVOS(
                    sysPlatformMenusRepoProc.listByMenusType(
                                    menusTypes).stream()
                            .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                            .filter(t -> Boolean.TRUE.equals(t.getMenusState()))
                            .collect(Collectors.toList())
            );
        }
        return ApiResult.ok(getAppMenusVO);
    }

    @Override
    public ApiResult<List<MenusAndOperationNumVO>> getAllAppMenusApi(String appCode) {
        return ApiResult.ok(sysPlatformMenusRepoProc.getMenusSumApi(appCode));
    }

    @Override
    public ApiResult<List<MenusAndOperationNumVO>> listMenusByAppCode(String appCode) {
        var respVoList = sysPlatformMenusRepoProc.getMenusAndCountOperation(appCode);
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<Boolean> addMenusApi(AddMenusApiParam addMenusApiParam) {
        if (addMenusApiParam.getApiId() == null) {
            return ApiResult.fail("接口数据异常");
        }
        var menusApis = sysPlatformMenusApiRepo.findAllByAppIdAndMenusId(addMenusApiParam.getAppId(), addMenusApiParam.getMenusId());
        menusApis.forEach(sysPlatformMenusApiDO -> {
            if (Objects.equals(sysPlatformMenusApiDO.getApiId(), addMenusApiParam.getApiId())) {
                throw new BusinessException("接口已挂载");
            }
        });
        var apiCode = sysPlatformApiManageRepoProc.getCode(addMenusApiParam.getApiId());
        var saveDo = SysPlatformMenusApiConvert.INSTANCE.saveParamToDo(addMenusApiParam);
        saveDo.setApiCode(apiCode);
        sysPlatformMenusApiRepo.save(saveDo);

        // 清空缓存
        clearCache();
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<Boolean> deleteMenusApi(DeleteMenusApiParam deleteMenusApiParam) {
        var sysPlatformMenusApiDO = sysPlatformMenusApiRepo.findByAppIdAndMenusIdAndApiId(deleteMenusApiParam.getAppId(), deleteMenusApiParam.getMenusId(), deleteMenusApiParam.getApiId());
        Assert.notNull(sysPlatformMenusApiDO, "数据不存在");
        sysPlatformMenusApiRepo.delete(sysPlatformMenusApiDO);

        // 清空缓存
        clearCache();
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<List<MenusApiVO>> getMenusApis(Long appId, Long menusId) {
        var voList = new ArrayList<MenusApiVO>();
        var menusApiDo = sysPlatformMenusApiRepo.findAllByAppIdAndMenusId(appId, menusId);
        for (SysPlatformMenusApiDO menusApi : menusApiDo) {
            var sysPlatformApiManageDO = sysPlatformApiManageRepo.findById(menusApi.getApiId());
            if (sysPlatformApiManageDO.isPresent()) {
                var menusApiVO = SysPlatformApiMangeConvert.INSTANCE.doToVo(sysPlatformApiManageDO.get());
                voList.add(menusApiVO);
            } else {
                throw new BusinessException("apiId: " + menusApi.getApiId() + "不存在");
            }
        }
        return ApiResult.ok(voList);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> saveMenuOperation(MenuOperationSaveVO saveVO) {
        if (CharSequenceUtil.isBlank(saveVO.getMenuCode())) {
            return ApiResult.fail("菜单编码为空");
        }

        // 菜单信息
        var menuDO = sysPlatformMenusRepoProc.getByMenusCode(saveVO.getMenuCode());
        if (menuDO == null) {
            return ApiResult.fail("菜单不存在");
        }
        // 是否增量
        boolean increment = saveVO.getIncremental() == null || saveVO.getIncremental();

        if (increment) {
            // 获取已绑定的操作信息
            var existsOperationCodes = menuOperationRepoProc.getOperationCodesByMenuCode(menuDO.getMenusCode());
            List<SysMenuOperationDO> menuOperationDoList = CollUtil.isEmpty(saveVO.getOperationCodes()) ? Collections.emptyList() :
                    saveVO.getOperationCodes().stream()
                            .filter(t -> !existsOperationCodes.contains(t))
                            .map(t -> {
                                SysMenuOperationDO menuOperationDO = new SysMenuOperationDO();
                                menuOperationDO.setAppCode(menuDO.getMenusAppCode());
                                menuOperationDO.setMenusCode(menuDO.getMenusCode());
                                menuOperationDO.setOperationCode(t);
                                return menuOperationDO;
                            }).collect(Collectors.toList());
            if (!menuOperationDoList.isEmpty()) {
                menuOperationRepoProc.save(menuOperationDoList);
            }
            return ApiResult.ok(true);
        }

        // 删除已有的
        menuOperationRepoProc.deleteByMenu(menuDO.getMenusCode());
        // 保存新的
        List<SysMenuOperationDO> menuOperationDoList = CollUtil.isEmpty(saveVO.getOperationCodes()) ? Collections.emptyList() :
                saveVO.getOperationCodes().stream()
                        .map(t -> {
                            SysMenuOperationDO menuOperationDO = new SysMenuOperationDO();
                            menuOperationDO.setAppCode(menuDO.getMenusAppCode());
                            menuOperationDO.setMenusCode(menuDO.getMenusCode());
                            menuOperationDO.setOperationCode(t);
                            return menuOperationDO;
                        }).collect(Collectors.toList());
        if (!menuOperationDoList.isEmpty()) {
            menuOperationRepoProc.save(menuOperationDoList);
        }
        return ApiResult.ok(true);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> deleteMenuOperation(MenuOperationDelVO delVO) {
        if (CharSequenceUtil.isBlank(delVO.getMenuCode()) || CollUtil.isEmpty(delVO.getOperationCodes())) {
            return ApiResult.fail("缺少必要参数");
        }

        menuOperationRepoProc.delete(delVO.getMenuCode(), delVO.getOperationCodes());
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<List<MenuOperationRespVO>> listMenuOperation(String menuCode) {
        if (CharSequenceUtil.isBlank(menuCode)) {
            return ApiResult.fail("菜单编码为空");
        }

        var respVoList = menuOperationRepoProc.listOperationByMenuCode(menuCode);
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<List<MenuBasicRespVO>> listMenuOfOperation(String operationCode) {
        if (CharSequenceUtil.isBlank(operationCode)) {
            return ApiResult.fail("操作编码为空");
        }

        var respVoList = menuOperationRepoProc.listMenusOfOperation(operationCode);
        if (respVoList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }

        for (MenuBasicRespVO respVO : respVoList) {
            ObjUtil.ifNotNull(PlatformAppMenusTypeEnum.parse(respVO.getMenusType()), t -> respVO.setMenusTypeName(t.getDescription()));
            ObjUtil.ifNotNull(PlatformMenusNodeEnum.parse(respVO.getNodeType()), t -> respVO.setNodeTypeName(t.getDescription()));
        }
        return ApiResult.ok(respVoList);
    }
    
    private void clearCache() {
        cacheMenuRpcService.clearCache();
    }
}
