package com.elitescloud.cloudt.platform.service.number;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Objects;

/**
 * 按照最近的自动编号实现逻辑，RV类型的编号逻辑，会通过app_code和number_pattern来关联
 * 下一编号配置，转为由下一编号来替代runtime value
 *
 * @author Michael Li
 * @since 3.3.0
 */
@Data
@Accessors(chain = true)
public class RuntimeValueOperator implements INumberOperator {
    private String numberType;
    private String numberPattern;
    private int numberLength;
    private int seq;

    private List<String> runtimeValues;

    private NextNumberOperator nextNumberOperator;

    @Override
    public String getNumberString() {
        if ("NN".equals(numberPattern) && !Objects.isNull(nextNumberOperator)) {
            return nextNumberOperator.getNumberString();
        }

        if (seq < runtimeValues.size()) {
            return runtimeValues.get(seq);
        }

        return "rv-err";
    }
}
