package com.elitescloud.cloudt.platform.service.repo.number;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformNumberRuleDtlDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDtlDO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleDtlDTO;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/08/09
 */
@Repository
public class SysPlatformNumberRuleDtlRepoProc extends BaseRepoProc<SysPlatformNumberRuleDtlDO> {
    private static final QSysPlatformNumberRuleDtlDO QDO = QSysPlatformNumberRuleDtlDO.sysPlatformNumberRuleDtlDO;

    public SysPlatformNumberRuleDtlRepoProc() {
        super(QDO);
    }

    public long deleteByRuleId(@NonNull Long ruleId) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.ruleId.eq(ruleId))
                .execute();
    }

    public long deleteByRuleId(@NonNull Collection<Long> ruleId) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.ruleId.in(ruleId))
                .execute();
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }

    public Long getRuleId(@NonNull Long id) {
        return getValue(QDO.ruleId, id);
    }

    public List<SysPlatformNumberRuleDtlDO> queryDetails(@NonNull Long ruleId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.ruleId.eq(ruleId))
                .orderBy(QDO.seq.asc())
                .fetch();
    }

    public List<SysPlatformNumberRuleDtlDO> queryDetails(@NonNull List<Long> ruleId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.ruleId.in(ruleId))
                .fetch();
    }

    public List<SysPlatformNumberRuleDtlDTO> queryByRuleId(@NonNull Long ruleId) {
        return jpaQueryFactory.select(QDO.seq, QDO.numberType, QDO.numberPattern, QDO.nnLen)
                .from(QDO)
                .where(QDO.ruleId.eq(ruleId))
                .fetch()
                .stream()
                .map(tuple -> {
                    var dto = new SysPlatformNumberRuleDtlDTO();
                    dto.setSeq(ObjectUtil.defaultIfNull(tuple.get(QDO.seq), 0));
                    dto.setNumberType(tuple.get(QDO.numberType));
                    dto.setNumberPattern(tuple.get(QDO.numberPattern));
                    dto.setNnLen(tuple.get(QDO.nnLen));

                    return dto;
                }).sorted(Comparator.comparingInt(SysPlatformNumberRuleDtlDTO::getSeq))
                .collect(Collectors.toList());
    }
}
