package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleDtlVO;
import com.elitescloud.cloudt.platform.service.ISysPlatformNumberRuleDtlService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 发号器规则明细管理
 *
 * @author Michael Li
 * 2020-10-11
 */
@RestController
@RequestMapping("/sys/platform/numbering/ruledtls")
@Api(value = "发号器-发号器规则明细管理", tags = {"发号器-发号器规则明细管理"})
@BusinessObject(businessType = BusinessObjectConstant.SYS_PLATFORM_NUMBER_RULE, businessDoClass = SysPlatformNumberRuleDO.class)
public class SysPlatformNumberRuleDtlController {

    private final ISysPlatformNumberRuleDtlService sysNumberRuleDtlService;

    public SysPlatformNumberRuleDtlController(ISysPlatformNumberRuleDtlService sysNumberRuleDtlService) {
        this.sysNumberRuleDtlService = sysNumberRuleDtlService;
    }

    /**
     * 批量创建或更换规则明细
     *
     * @param details 规则明细
     * @return 保存结果
     */
    @PostMapping
    @ApiOperation("批量创建或更换规则明细")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SAVE,operationDescription = "批量创建或更换规则明细",
            logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> updateInBatch(@RequestBody @Valid List<SysPlatformNumberRuleDtlVO> details) {
        return sysNumberRuleDtlService.updateInBatch(details);
    }

    /**
     * 批量删除规则明细
     *
     * @param ids 规则明细ID
     * @return 删除结果
     */
    @DeleteMapping
    @ApiOperation("根据规则明细ID列表，批量删除规则明细")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.DELETE,operationDescription = "删除规则明细",
            logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Object> removeInBatch(@RequestBody List<Long> ids) {
        sysNumberRuleDtlService.removeByIds(ids);
        return ApiResult.ok();
    }
}
