package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalDate;

/**
 * 节假日信息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/25 周五
 */
@Entity
@Table(name = "sys_platform_holiday", indexes = {
        @Index(name = "idx_sys_holiday_year", columnList = "belongYear"),
        @Index(name = "idx_sys_holiday_date", columnList = "onDate"),
})
@Comment("节假日信息")
@DynamicInsert
@Getter
@Setter
public class SysPlatformHolidayDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = 2933183088134951785L;

    @Comment(value = "所属年份")
    @Column(nullable = false)
    private Integer belongYear;

    @Comment(value = "所在日期")
    @Column(nullable = false)
    private LocalDate onDate;

    @Comment(value = "是否工作日(调休上班)", defaultValue = "0")
    @Column()
    private Boolean workday;

    @Comment(value = "节假日类型[UDC]cloudt-system:holidayType, 多个逗号分隔")
    @Column()
    private String holidayTypes;

    @Comment(value = "节假日名称, 多个逗号分隔")
    @Column()
    private String holidayNames;

    @Comment(value = "是否法定节假日", defaultValue = "0")
    @Column()
    private Boolean legalUnify;
}
