package com.elitescloud.cloudt.platform.model.params.menus;

import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.20
 **/
@Data
public class AddMenusParam implements Serializable {
    private static final long serialVersionUID = 8354503515104537382L;

    @ApiModelProperty("菜单归属应用")
    @NotBlank
    private String menusAppCode;

    @ApiModelProperty("菜单名称")
    @NotBlank
    private String menusName;

    @ApiModelProperty("菜单类型 业务-系统")
    private PlatformAppMenusTypeEnum menusType;

    @ApiModelProperty("菜单编码")
    @NotBlank
    private String menusCode;

    @ApiModelProperty("排序")
    private Integer menusOrder;

    @ApiModelProperty("上级菜单编码")
    private String menusParentCode;

    @ApiModelProperty("菜单路由")
    private String menusRoute;

    @ApiModelProperty("描述")
    private String menusDescribe;

    @ApiModelProperty("图标")
    private String menusIcon;

    @ApiModelProperty("是否展示")
    private Boolean display;

    @ApiModelProperty("是否外链接")
    private Boolean outerLink;

    @ApiModelProperty("外链接类型")
    private PlatformMenusOuterLinkTypeEnum outerLinkType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "扩展信息")
    private Map<String, Object> ext;
}
