package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_udc_value", description = "udc值")
public class SysPlatformUdcValueVO extends BaseModel implements Serializable {
    @ApiModelProperty("应用编码")
    private String appCode;

    @ApiModelProperty("udc编码")
    private String udcCode;

    @ApiModelProperty("值编码")
    private String udcValueCode;

    @ApiModelProperty("值名称")
    private String udcValueName;

    @ApiModelProperty(value = "值别名", position = 4)
    private String valueAliasName;

    @ApiModelProperty("排序")
    private Integer udcOrder;

    @ApiModelProperty("是否启用")
    private Boolean allowStart;

    @ApiModelProperty("描述")
    private String udcValueDescribe;

    @ApiModelProperty("是否内置")
    private Boolean allowDefault;

    @ApiModelProperty("上级UDC值编码")
    private String parentUdcValueCode;
}
