package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleAddParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleQParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleVO;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/6/17
 */
public interface ISysPlatformNumberRuleService {

    /**
     * 创建发号器规则
     *
     * @param rule 规则对象
     * @return 新建规则的ID
     */
    ApiResult<Long> create(SysPlatformNumberRuleAddParam rule);

    /**
     * 更新发号器规则
     *
     * @param rule 规则对象
     */
    ApiResult<Long> update(SysPlatformNumberRuleAddParam rule);

    /**
     * 更新启用状态
     *
     * @param id
     * @return
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 删除发号器规则
     *
     * @param id 规则ID
     */
    ApiResult<Boolean> removeById(Long id);

    /**
     * 检索发号器规则
     *
     * @param param 检索条件对象
     * @return 分页的规则集合
     */
    ApiResult<PagingVO<SysPlatformNumberRuleVO>> search(SysPlatformNumberRuleQParam param);

    /**
     * 根据发号规则ID，生成样例号
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 基于UDC选择值的列表
     * @return 生成样例号，下一编号用默认，1
     */
    ApiResult<String> generateSampleCode(Long ruleId, List<String> runtimeValues);

    /**
     * 根据发号规则编码，生成样例号
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 基于UDC选择值的列表
     * @return 生成样例号，洗衣编号默认用，1
     */
    ApiResult<String> generateSampleCode(String ruleCode, List<String> runtimeValues);

    /**
     * 根据发号规则ID，生成对应号码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 选择的UDC的值列表
     * @return 生成的号码
     */
    ApiResult<String> generateCode(Long ruleId, List<String> runtimeValues);

    /**
     * 根据发号规则编码，生成对应号码
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 选择UDC的值列表
     * @return 生成的号码
     */
    ApiResult<String> generateCode(String ruleCode, List<String> runtimeValues);

    /**
     * 根据发号器规则ID，返回规则主信息和关联且排序的规则明细
     *
     * @param id 规则ID
     * @return 规则对象
     */
    ApiResult<SysPlatformNumberRuleVO> oneCombined(Long id);
}
