package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiManageDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

@Repository
public class SysPlatformApiManageRepoProc extends BaseRepoProc<SysPlatformApiManageDO> {
    private static final QSysPlatformApiManageDO QDO = QSysPlatformApiManageDO.sysPlatformApiManageDO;

    public SysPlatformApiManageRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }

    public String getCode(long id) {
        return super.getValue(QDO.apiCode, id);
    }

    public boolean existsCode(@NotBlank String code, Long id) {
        return exists(QDO.apiCode, code, id);
    }
}
