package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class SysPlatformMenusApiRepoProc extends BaseRepoProc<SysPlatformMenusApiDO> {
    private static final QSysPlatformMenusApiDO QDO = QSysPlatformMenusApiDO.sysPlatformMenusApiDO;

    public SysPlatformMenusApiRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }

    /**
     * 根据菜单编码删除
     *
     * @param menuCode 菜单编码
     */
    public void deleteByMenuCode(@NotBlank String menuCode) {
        super.deleteByValue(QDO.menusCode, menuCode);
    }

    /**
     * 查询列表
     *
     * @param apiId
     * @param appCode
     * @return
     */
    public List<SysPlatformMenusApiDO> queryListByApi(long apiId, String appCode) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.apiId, apiId)
                .andEq(QDO.appCode, appCode)
                .build();
        return super.getList(predicate);
    }

    /**
     * 统计接口关联的菜单数
     *
     * @param apiIds
     * @return
     */
    public Map<Long, Long> countMenuOfApi(Collection<Long> apiIds) {
        return jpaQueryFactory.select(QDO.apiId, QDO.menusId)
                .from(QDO)
                .where(QDO.apiId.in(apiIds))
                .fetch()
                .stream()
                .collect(Collectors.groupingBy(t -> t.get(QDO.apiId), Collectors.counting()));
    }
}
