package com.elitescloud.cloudt.platform.service.repo.number;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformNextNumberDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * 2020-10-11
 */
@Repository
public class SysPlatformNextNumberRepoProc extends BaseRepoProc<SysPlatformNextNumberDO> {
    private static final QSysPlatformNextNumberDO QDO = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;

    public SysPlatformNextNumberRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }
}
