/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.SearchResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.SysPlatformApiMangeConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformApiParameterConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformApiFieldTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformApiRequestTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiParameterDO;
import com.elitescloud.cloudt.platform.model.params.api.AddApiParam;
import com.elitescloud.cloudt.platform.model.params.api.ApiFieldParam;
import com.elitescloud.cloudt.platform.model.vo.sbean.SysApiManageQueryBean;
import com.elitescloud.cloudt.platform.service.SysPlatformApiManageService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformApiManageRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformApiParameterRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusApiRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusApiRepoProc;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysPlatformApiManageServiceImpl
implements SysPlatformApiManageService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformApiManageServiceImpl.class);
    private final SysPlatformApiManageRepo sysPlatformApiManageRepo;
    private final SysPlatformApiParameterRepo sysPlatformApiParameterRepo;
    private final SysPlatformMenusApiRepo sysPlatformMenusApiRepo;
    private final SysPlatformMenusApiRepoProc menusApiRepoProc;
    private final BeanSearcher beanSearcher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addApi(AddApiParam addApiParam) {
        SysPlatformApiManageDO saveDo = SysPlatformApiMangeConvert.INSTANCE.saveParamToDo(addApiParam);
        List<SysPlatformApiManageDO> list = this.sysPlatformApiManageRepo.findByApiCode(saveDo.getApiCode());
        if (!list.isEmpty()) {
            return ApiResult.fail((String)"\u63a5\u53e3\u7f16\u7801\u91cd\u590d");
        }
        saveDo.setRequestType(addApiParam.getRequestType().name());
        this.sysPlatformApiManageRepo.save((Object)saveDo);
        Long apiId = saveDo.getId();
        this.saveFields(apiId, addApiParam.getApiCode(), addApiParam.getInParams(), "IN");
        this.saveFields(apiId, addApiParam.getApiCode(), addApiParam.getOutParams(), "OUT");
        return ApiResult.ok((Object)apiId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateApi(Long id, AddApiParam updateApiParam) {
        this.sysPlatformApiManageRepo.findById(id).ifPresentOrElse(manageDO -> {
            Assert.isTrue((boolean)CharSequenceUtil.equals((CharSequence)manageDO.getApiCode(), (CharSequence)updateApiParam.getApiCode()), (String)"\u63a5\u53e3\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
            Assert.isTrue((boolean)CharSequenceUtil.equals((CharSequence)manageDO.getAppCode(), (CharSequence)updateApiParam.getAppCode()), (String)"\u6240\u5c5e\u5e94\u7528\u4e0d\u53ef\u4fee\u6539");
            manageDO.setApiName(updateApiParam.getApiName());
            manageDO.setApiPath(updateApiParam.getApiPath());
            manageDO.setRequestType(updateApiParam.getRequestType().name());
            manageDO.setApiDescribe(updateApiParam.getApiDescribe());
            this.sysPlatformApiParameterRepo.deleteAllByApiId(id);
            this.sysPlatformApiManageRepo.save(manageDO);
            this.saveFields(id, updateApiParam.getApiCode(), updateApiParam.getInParams(), "IN");
            this.saveFields(id, updateApiParam.getApiCode(), updateApiParam.getOutParams(), "OUT");
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteApi(Long id) {
        Optional sysPlatformManageDo = this.sysPlatformApiManageRepo.findById(id);
        if (!sysPlatformManageDo.isPresent()) {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        }
        this.sysPlatformApiParameterRepo.deleteAllByApiId(id);
        this.sysPlatformApiManageRepo.deleteById(id);
        this.sysPlatformMenusApiRepo.deleteAllByApiId(id);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<PagingVO<SysApiManageQueryBean>> query(Map<String, Object> param) {
        SearchResult obj = this.beanSearcher.search(SysApiManageQueryBean.class, param);
        List<Long> apiIds = obj.getDataList().stream().map(BaseModel::getId).collect(Collectors.toList());
        Map apiMenuNumMap = apiIds.isEmpty() ? Collections.emptyMap() : this.menusApiRepoProc.countMenuOfApi(apiIds);
        ArrayList<SysApiManageQueryBean> result = new ArrayList<SysApiManageQueryBean>();
        for (SysApiManageQueryBean s : obj.getDataList()) {
            s.setMenuNum(apiMenuNumMap.getOrDefault(s.getId(), 0L));
            s.setInParams(this.sysPlatformApiParameterRepo.findAllByApiIdAndInOutType(s.getId(), "IN").stream().map(SysPlatformApiParameterConvert.INSTANCE::doToVo).collect(Collectors.toList()));
            s.setOutParams(this.sysPlatformApiParameterRepo.findAllByApiIdAndInOutType(s.getId(), "OUT").stream().map(SysPlatformApiParameterConvert.INSTANCE::doToVo).collect(Collectors.toList()));
            result.add(s);
        }
        PagingVO page = new PagingVO(obj.getTotalCount().longValue(), result);
        return ApiResult.ok((Object)page);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getApiRequestTypeEnum() {
        return ApiResult.ok(List.of(PlatformApiRequestTypeEnum.GET.getUdcVO(), PlatformApiRequestTypeEnum.POST.getUdcVO(), PlatformApiRequestTypeEnum.PUT.getUdcVO(), PlatformApiRequestTypeEnum.DELETE.getUdcVO()));
    }

    @Override
    public ApiResult<List<SysUdcVO>> getApiFieldTypeEnum() {
        return ApiResult.ok(List.of(PlatformApiFieldTypeEnum.TEXT.getUdcVO(), PlatformApiFieldTypeEnum.NUMBER.getUdcVO(), PlatformApiFieldTypeEnum.DATE.getUdcVO()));
    }

    private void saveFields(Long id, String code, List<ApiFieldParam> list, String inOutType) {
        if (list != null) {
            for (ApiFieldParam field : list) {
                SysPlatformApiParameterDO sysPlatformApiParameterDO = new SysPlatformApiParameterDO();
                sysPlatformApiParameterDO = SysPlatformApiParameterConvert.INSTANCE.saveParamToDo(field);
                sysPlatformApiParameterDO.setApiId(id);
                sysPlatformApiParameterDO.setApiCode(code);
                sysPlatformApiParameterDO.setFieldType(field.getFieldType().name());
                sysPlatformApiParameterDO.setInOutType(inOutType);
                this.sysPlatformApiParameterRepo.save((Object)sysPlatformApiParameterDO);
            }
        }
    }

    public SysPlatformApiManageServiceImpl(SysPlatformApiManageRepo sysPlatformApiManageRepo, SysPlatformApiParameterRepo sysPlatformApiParameterRepo, SysPlatformMenusApiRepo sysPlatformMenusApiRepo, SysPlatformMenusApiRepoProc menusApiRepoProc, BeanSearcher beanSearcher) {
        this.sysPlatformApiManageRepo = sysPlatformApiManageRepo;
        this.sysPlatformApiParameterRepo = sysPlatformApiParameterRepo;
        this.sysPlatformMenusApiRepo = sysPlatformMenusApiRepo;
        this.menusApiRepoProc = menusApiRepoProc;
        this.beanSearcher = beanSearcher;
    }
}

