package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 通用平台接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@Api(tags = "通用接口")
@RestController
@RequestMapping(value = "/platform/common", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SysPlatformCommonController {

    @Autowired
    private SysPlatformAppService appService;

    @ApiOperation(value = "应用列表")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "outerApp", value = "是否外部应用"),
            @ApiImplicitParam(name = "authed", value = "是否需要授权")
    })
    @GetMapping(value = "/listApp")
    public ApiResult<List<SysPlatformAppVO>> listApp(@RequestParam(value = "outerApp", required = false) Boolean outerApp,
                                                      @RequestParam(value = "authed", required = false) Boolean authed) {
        return appService.listApp(outerApp, authed);
    }

    @PostMapping("/queryApp")
    @ApiOperation(value = "分页查询应用")
    public ApiResult<PagingVO<SysPlatformAppVO>> queryApp(@RequestBody @Valid QueryAppParam queryAppParam) {
        return appService.queryByPage(queryAppParam);
    }
}
