package com.elitescloud.cloudt.platform.controller.api.extend;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAreaService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 行政区域管理.
 *
 * @author Kaiser（wang shao）
 * 2023/1/10
 */
@Api(tags = "行政区域管理")
@RestController
@RequestMapping(value = "/platform/mng/area", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_PLATFORM_AREA, businessDoClass = SysPlatformAreaDO.class)
public class SysPlatformAreaController {

    private final SysPlatformAreaService sysPlatformAreaService;

    public SysPlatformAreaController(SysPlatformAreaService sysPlatformAreaService) {
        this.sysPlatformAreaService = sysPlatformAreaService;
    }

    @GetMapping(value = "/tree")
    @ApiOperation(value = "行政区域树")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParam(name = "tree", value = "是否返回树状，默认false", defaultValue = "false")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "行政区域树"
    )
    public ApiResult<List<AreaMngTreeRespVO>> tree(@RequestParam(name = "tree", defaultValue = "false") Boolean tree) {
        return sysPlatformAreaService.tree(tree);
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存行政区域")
    @ApiOperationSupport(order = 2)
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SAVE,operationDescription = "保存行政区域"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> save(@RequestBody @Valid PlatformAreaSaveVO saveVO) {
        return sysPlatformAreaService.save(saveVO);
    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "获取行政区域详情")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "区域ID", required = true)
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "行政区域详情"
    )
    public ApiResult<AreaDetailRespVO> get(@PathVariable("id") Long id) {
        return sysPlatformAreaService.get(id);
    }

    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "删除行政区域详情")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "id", value = "区域ID", required = true)
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.DELETE,operationDescription = "删除行政区域"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> delete(@PathVariable("id") Long id) {
        return sysPlatformAreaService.delete(id);
    }

    @PutMapping(value = "/tree/rebuild")
    @ApiOperation(value = "【调试】重构行政区域树")
    @ApiOperationSupport(order = 5)
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "重构行政区域树",
            operationScopeEnum = OperationScopeEnum.PRIVATE_TEST,operationStateEnum = OperationStateEnum.TESTING
    )
    public ApiResult<Boolean> treeRebuild() {
        return sysPlatformAreaService.execReBuildTree();
    }
}
