package com.elitescloud.cloudt.platform.controller.rpc;//package com.elitescloud.cloudt.platform.controller.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.platform.service.SysPlatformDatabaseSourceService;
import com.elitescloud.cloudt.system.datasource.*;
import com.elitescloud.cloudt.system.datasource.service.SysPlatformDatabaseSourceRpcService;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping(value = SysPlatformDatabaseSourceRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@TenantOrgTransaction(useTenantOrg = false)
@Slf4j
class SysPlatformDataBaseSourceRpcServiceImpl implements SysPlatformDatabaseSourceRpcService {
  private final  SysPlatformDatabaseSourceService sysPlatformDatabaseSourceService;

    SysPlatformDataBaseSourceRpcServiceImpl(SysPlatformDatabaseSourceService sysPlatformDatabaseSourceService) {
        this.sysPlatformDatabaseSourceService = sysPlatformDatabaseSourceService;
    }

    @Override
    public ApiResult<List<SysPlatformDatabaseSourceVO>> query(SysPlatformDatabaseSourceQueryParam queryParam) {
        return sysPlatformDatabaseSourceService.query(queryParam);
    }

    @Override
    public ApiResult<String> queryPasswordById(Long id) {
        return sysPlatformDatabaseSourceService.queryPasswordById(id);
    }

    @Override
    public ApiResult<SysPlatformDatabaseSourceVO> getById(Long id) {
        return sysPlatformDatabaseSourceService.getById(id);
    }

    @Override
    public ApiResult<SysPlatformDatabaseSourceVO> getByDbsCode(String dbsCode) {
        return sysPlatformDatabaseSourceService.getByDbsCode(dbsCode);
    }

    @Override
    public ApiResult<Long> save(SysPlatformDatabaseSourceSaveParam saveParam) {
        return sysPlatformDatabaseSourceService.save(saveParam);
    }

    @Override
    public ApiResult<Long> update(Long id, SysPlatformDatabaseSourceUpParam upParam) {
        return sysPlatformDatabaseSourceService.update(id, upParam);
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        return sysPlatformDatabaseSourceService.delete(id);
    }

    @Override
    public ApiResult<String> testConnection(DatabaseConfigDTO config) {
        return sysPlatformDatabaseSourceService.testConnection(config);
    }

    @Override
    public ApiResult<String> testConnectionById(Long dbDataSourceId) {
        return sysPlatformDatabaseSourceService.testConnectionById(dbDataSourceId);
    }
}
