package com.elitescloud.cloudt.platform.model.constant;

import cn.hutool.core.text.CharSequenceUtil;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * SQL执行类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/27
 */
public enum SqlTypeEnum {

    /**
     * 统计
     */
    COUNT("统计"),
    /**
     * 查询列表
     */
    SELECT_LIST("查询列表"),
    /**
     * 更新
     */
    UPDATE("修改"),
    /**
     * 插入
     */
    INSERT("新增"),
    /**
     * 删除
     */
    DELETE("删除");

    private final String description;

    SqlTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }


    private static final Map<String, SqlTypeEnum> ALL = Arrays.stream(SqlTypeEnum.values())
            .collect(Collectors.toMap(SqlTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析类型
     *
     * @param value 待解析字符串
     * @return
     */
    public static SqlTypeEnum parse(String value) {
        if (CharSequenceUtil.isBlank(value)) {
            return null;
        }
        return ALL.get(value);
    }
}
