package com.elitescloud.cloudt.platform.model.constant;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;
import java.io.Serial;

/**
 * 节假日类型.
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/25 周五
 */
public class SysHolidayType extends BaseUdc<SysHolidayType> {
    @Serial
    private static final long serialVersionUID = 4015160078608016484L;

    public static final SysHolidayType YUAN_DAN = new SysHolidayType("yuan_dan", "元旦");
    public static final SysHolidayType CHUN_JIE = new SysHolidayType("chun_jie", "春节");
    public static final SysHolidayType QING_MING = new SysHolidayType("qing_ming", "清明");
    public static final SysHolidayType LAO_DONG = new SysHolidayType("lao_dong", "劳动");
    public static final SysHolidayType duan_wu = new SysHolidayType("duan_wu", "端午");
    public static final SysHolidayType guo_qing = new SysHolidayType("guoqing", "国庆");
    public static final SysHolidayType zhong_qiu = new SysHolidayType("zhong_qiu", "中秋");

    public SysHolidayType() {
    }

    public SysHolidayType(String value) {
        super(value);
    }

    public SysHolidayType(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String getUdcCode() {
        return "holidayType";
    }
}
