package com.elitescloud.cloudt.platform.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/8 17:23
 */

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.GeneratedValue;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 服务租户数据源配置;
 * @author : http://www.chiner.pro
 * @date : 2023-10-8
 */
@ApiModel(value = "服务租户数据源配置",description = "")
@Table(name="sys_database_service_tenant")
@org.hibernate.annotations.Table(appliesTo = "sys_database_service_tenant", comment = "服务租户数据源配置")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysDatabaseServiceTenantDO extends BaseModel implements Serializable {

    /**
     * 数据源名称
     */
    @ApiModelProperty(name = "数据源名称", notes = "")
    private String dbsName;
    /**
     * 驱动类
     */
    @ApiModelProperty(name = "驱动类", notes = "")
    private String dbsDriverClass;
    /**
     * 服务器地址
     */
    @ApiModelProperty(name = "服务器地址字符串{dbsNetaddress}{dbsDbPort}{dbsDbName}占位", notes = "")
    private String dbsUrl;
    /**
     * 数据库名称
     */
    @ApiModelProperty(name = "数据库名称", notes = "")
    private String dbsDbName;
    /**
     * 数据库端口
     */
    @ApiModelProperty(name = "数据库端口", notes = "")
    private String dbsDbPort;
    /**
     * 账号
     */
    @ApiModelProperty(name = "账号", notes = "")
    private String dbsUsername;
    /**
     * 密码
     */
    @ApiModelProperty(name = "密码", notes = "")
    private String dbsPassword;

    @ApiModelProperty(name = "数据库网络地址", notes = "")
    private String dbsNetaddress;
    /**
     * 服务编码
     */
    @ApiModelProperty(name = "服务编码", notes = "")
    private String serviceCode;
    /**
     * 数据源租户编码
     */
    @ApiModelProperty(name = "数据源租户编码", notes = "")
    private String tenantCode;

    /**
     * 租户组织ID
     */
    @ApiModelProperty(name = "租户组织ID", notes = "")
    private Long tenantOrgId;
}
