package com.elitescloud.cloudt.platform.model.params.app;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.16
 **/
@Data
@ApiModel(description = "应用信息")
public class AddAppParam implements Serializable {

    private static final long serialVersionUID = 3535949072666254663L;

    @ApiModelProperty(value = "应用编码", required = true, position = 1)
    @NotBlank(message = "应用编码为空")
    private String appCode;

    @ApiModelProperty(value = "应用名称", required = true, position = 2)
    @NotBlank(message = "应用名称为空")
    private String appName;

    @ApiModelProperty(value = "应用类型", required = true, position = 3)
    @NotBlank(message = "应用类型为空")
    private String appType;

    /**
     * @see com.elitescloud.cloudt.system.constant.SysTerminalType
     */
    @ApiModelProperty(value = "适应的终端，[UDC]cloudt-system:terminalType")
    private String adaptedTerminal;

    @ApiModelProperty(value = "应用图标", position = 3)
    private String icon;

    @ApiModelProperty(value = "启用状态", position = 4)
    private Boolean appState;

    @ApiModelProperty(value = "描述", position = 5)
    private String appDescribe;

    @ApiModelProperty(value = "排序", position = 6)
    private Integer appOrder;

    @ApiModelProperty(value = "是否外部应用", position = 7)
    private Boolean outerApp;

    @ApiModelProperty(value = "授权类型", position = 8)
    private String authType;

    @ApiModelProperty(value = "访问URL", position = 9)
    private String url;

    @ApiModelProperty(value = "生成token的URL", position = 10)
    private String tokenUrl;
}
