package com.elitescloud.cloudt.platform.model.params.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.16
 **/
@Data
@ApiModel(description = "应用更新信息")
public class UpdateAppParam implements Serializable {
    private static final long serialVersionUID = -6153525808562350490L;
//    @ApiModelProperty("应用编码")
//    String appCode;

    @ApiModelProperty(value = "应用名称", required = true, position = 1)
    @NotBlank(message = "应用名称为空")
    private String appName;

    @ApiModelProperty(value = "应用类型", position = 2)
    @NotBlank(message = "应用类型为空")
    private String appType;

    /**
     * @see com.elitescloud.cloudt.system.constant.SysTerminalType
     */
    @ApiModelProperty(value = "适应的终端，[UDC]cloudt-system:terminalType")
    private String adaptedTerminal;

    @ApiModelProperty(value = "应用图标", position = 2)
    private String icon;

    @ApiModelProperty(value = "描述", position = 3)
    private String appDescribe;

    @ApiModelProperty(value = "排序", position = 4)
    private Integer appOrder;

    @ApiModelProperty(value = "是否外部应用", position = 7)
    private Boolean outerApp;

    @ApiModelProperty(value = "授权类型", position = 8)
    private String authType;

    @ApiModelProperty(value = "访问URL", position = 9)
    private String url;

    @ApiModelProperty(value = "生成token的URL", position = 10)
    private String tokenUrl;
}
