package com.elitescloud.cloudt.platform.model.params.sql;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Lob;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/25 13:03
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@ApiModel(description = "SysPlatformSqlExecuteParam")
public class SysPlatformSqlExecuteParam extends AbstractOrderQueryParam {

    /** 数据源名称 */
    @ApiModelProperty(value = "SQL命令命名，方便前端显示")
    private String sqlName ;
    /** 驱动类 */
    @ApiModelProperty(value = "存储SQL命令")
    private String querySql ;
    /** 连接地址 */
    @ApiModelProperty(value = "数据源的标识或名称")
    private String datasourceName ;

    @ApiModelProperty(value = "SQL编码")
    private String sqlCode;

    @ApiModelProperty(value = "分类，[udc]cloudt-system:sqlCategory")
    private String category;

    @ApiModelProperty(value = "SQL类型")
    private String sqlType;

    @ApiModelProperty(value = "限制结果集大小")
    private Integer limitSize;
}
