package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;

@Getter
@Setter
@ApiModel(description = "平台菜单接口表")
public class MenusAndOperationNumVO extends BaseViewModel {
    private static final long serialVersionUID = -8155768804180727511L;

    public MenusAndOperationNumVO() {
    }

    public MenusAndOperationNumVO(SysPlatformMenusDO sysPlatformMenusDO, Long apiNum
    ) {
        this.setId(sysPlatformMenusDO.getId());
        this.menusAppCode = sysPlatformMenusDO.getMenusAppCode();
        this.menusName = sysPlatformMenusDO.getMenusName();
        this.menusType = sysPlatformMenusDO.getMenusType();
        this.nodeType = sysPlatformMenusDO.getNodeType();
        this.menusCode = sysPlatformMenusDO.getMenusCode();
        this.menusOrder = sysPlatformMenusDO.getMenusOrder();
        this.menusState = sysPlatformMenusDO.getMenusState();
        this.menusParentCode = sysPlatformMenusDO.getMenusParentCode();
        this.menusRoute = sysPlatformMenusDO.getMenusRoute();
        this.menusDescribe = sysPlatformMenusDO.getMenusDescribe();
        this.menusIcon = sysPlatformMenusDO.getMenusIcon();
        this.display = sysPlatformMenusDO.getDisplay();
        this.outerLink = sysPlatformMenusDO.getOuterLink();
        this.outerLinkType = sysPlatformMenusDO.getOuterLinkType();
        this.remark = sysPlatformMenusDO.getRemark();
        this.ext = JSONUtil.json2Obj(sysPlatformMenusDO.getExtJson(), new TypeReference<>() {}, true, () -> "获取菜单" + sysPlatformMenusDO.getMenusCode() + "失败");
        this.apiNum = apiNum;
    }

    @ApiModelProperty("菜单归属应用")
    private String menusAppCode;

    @ApiModelProperty("菜单名称")
    private String menusName;

    @ApiModelProperty("菜单类型")
    private String menusType;

    @ApiModelProperty("节点类型 菜单,按钮")
    private String nodeType;

    @ApiModelProperty("菜单编码")
    private String menusCode;

    @ApiModelProperty("排序")
    private Integer menusOrder;

    @ApiModelProperty("菜单状态")
    private Boolean menusState;

    @ApiModelProperty("上级菜单编码")
    private String menusParentCode;

    @ApiModelProperty("菜单路由")
    private String menusRoute;

    @ApiModelProperty("描述")
    private String menusDescribe;

    @ApiModelProperty("图标")
    private String menusIcon;

    @ApiModelProperty("是否展示")
    private Boolean display;

    @ApiModelProperty("是否外链接")
    private Boolean outerLink;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("外链接类型")
    private PlatformMenusOuterLinkTypeEnum outerLinkType;

    @ApiModelProperty("挂载api数量")
    private Long apiNum;

    @ApiModelProperty(value = "扩展信息")
    private Map<String, Object> ext;
}
