package com.elitescloud.cloudt.platform.model.vo.extend.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 地区详情.
 *
 * @author Kaiser（wang shao）
 * 2023/1/10
 */
@Data
@ApiModel(description = "地区详情")
public class AreaDetailRespVO implements Serializable {
    private static final long serialVersionUID = 3985242192842023721L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 地区名称
     */
    @ApiModelProperty(value = "地区名称", position = 2)
    private String areaName;

    /**
     * 地区编码
     */
    @ApiModelProperty(value = "地区编码", position = 3)
    private String areaCode;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称", position = 4)
    private String shortName;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级地区编码", position = 5)
    private String parentAreaCode;

    /**
     * 上级名称
     */
    @ApiModelProperty(value = "上级名称", position = 5)
    private String parentAreaName;

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型", position = 6)
    private String areaType;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称", position = 6)
    private String areaTypeName;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编", position = 7)
    private String zipCode;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;

    /**
     * 顺序号
     */
    @ApiModelProperty(value = "顺序号", position = 9)
    private Integer sortNo;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 10)
    private String remark;
}
