package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyPageRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.CurrencySaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/29
 */
public interface SysPlatformCurrencyService {

    /**
     * 分页查询货币
     *
     * @param queryVO 查询参数
     * @return 货币列表
     */
    ApiResult<PagingVO<CurrencyPageRespVO>> page(CurrencyPageQueryVO queryVO);

    /**
     * 保存货币
     *
     * @param saveVO 货币信息
     * @return 货币ID
     */
    ApiResult<Long> save(CurrencySaveVO saveVO);

    /**
     * 删除货币信息
     *
     * @param id 货币ID
     * @return 货币ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用禁用
     *
     * @param id 货币ID
     * @return 切换结果
     */
    ApiResult<Long> switchEnabled(long id);

    /**
     * 获取货币详情
     *
     * @param id 货币ID
     * @return 货币详情
     */
    ApiResult<CurrencyDetailRespVO> get(Long id);
}
