package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformSqlExecuteDO;
import com.elitescloud.cloudt.platform.model.params.sql.SysPlatformSqlExecuteParam;
import com.elitescloud.cloudt.platform.model.vo.SqlExecuteDataVo;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/25 12:56
 */
public interface SysPlatformSqlExecuteService {

    ApiResult<String> importData(List<SqlExecuteDataVo> dataVoList);
    String getSqlByReplaceAll(String sql);
    ApiResult<PagingVO<SysPlatformSqlExecuteDO>> page( SysPlatformSqlExecuteParam queryVO);
    ApiResult<Long> add( SysPlatformSqlExecuteParam addParam);
    ApiResult<Boolean> update(Long id, SysPlatformSqlExecuteParam updateParam);
    ApiResult<SysPlatformSqlExecuteDO> findById(Long id);
    ApiResult<Boolean> deleteByIds( List<Long> ids);

    ApiResult<SysPlatformSqlExecuteDO> executeQuery( Long id);

}
