package com.elitescloud.cloudt.platform.service.number;

import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 共用的编号器日期格式类型的构建器
 * 按系统日期变化，自动变化
 *
 * @author Michael Li
 * @since 3.3.0
 */
@Service
public class DatePatternBuilder {
    private LocalDate currentDate = LocalDate.now();

    private final Map<String, String> patternValues = new ConcurrentHashMap<>();

    public String getPatternDate(String pattern) {
        if (!currentDate.isEqual(LocalDate.now())) {
            currentDate = LocalDate.now();
            patternValues.clear();
        }

        return patternValues.computeIfAbsent(pattern, key -> LocalDateTime.now().format(DateTimeFormatter.ofPattern(key)));
    }
}
