package com.elitescloud.cloudt.platform.service.number;

import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDtlDO;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNextNumberRepo;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleDtlRepo;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleRepo;
import lombok.val;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 下一编号发号管理器，先实现号码段的管理，后续扩展多种模式的下一编号管理
 */
@Service
public class SysPlatFormNextNumberMngService {

    private final String NUM_SEG_PREFIX = "cloudtnumseg:";

    private final String NN_SCRIPT = "local max = redis.pcall(\"HGET\", KEYS[1], \"max\")\n" +
            "local cur = redis.pcall(\"HGET\", KEYS[1], \"cur\")\n" +
            "if tonumber(cur) >= tonumber(max) then\n" +
            "  \tlocal step = ARGV[1]\n" +
            "  \tif (step == nil) then\n" +
            "    \t\t\tstep = redis.pcall(\"HGET\", KEYS[1], \"step\")\n" +
            "  \tend\n" +
            "  \tredis.pcall(\"HSET\", KEYS[1], \"max\", tonumber(max) + tonumber(step))\n" +
            "end\n" +
            "return redis.pcall(\"HINCRBY\", KEYS[1], \"cur\", 1)";

    private final RedissonClient redissonClient;

    private final SysPlatformNumberRuleRepo sysPlatformNumberRuleRepo;
    private final SysPlatformNumberRuleDtlRepo sysPlatformNumberRuleDtlRepo;
    private final SysPlatformNextNumberRepo sysPlatformNextNumberRepo;

    private final DatePatternBuilder datePatternBuilder;


    private final Map<String, String> dataPatternValues = new ConcurrentHashMap<>();

    public SysPlatFormNextNumberMngService(RedissonClient redissonClient,
                                           SysPlatformNumberRuleRepo sysPlatformNumberRuleRepo,
                                           SysPlatformNumberRuleDtlRepo sysPlatformNumberRuleDtlRepo,
                                           SysPlatformNextNumberRepo sysPlatformNextNumberRepo,
                                           DatePatternBuilder datePatternBuilder) {
        this.redissonClient = redissonClient;
        this.sysPlatformNumberRuleRepo = sysPlatformNumberRuleRepo;
        this.sysPlatformNumberRuleDtlRepo = sysPlatformNumberRuleDtlRepo;
        this.sysPlatformNextNumberRepo = sysPlatformNextNumberRepo;
        this.datePatternBuilder = datePatternBuilder;
    }

//    @PostConstruct
    public void init() {
        val allRules = this.sysPlatformNumberRuleRepo.findAll();
        val allDetails = this.sysPlatformNumberRuleDtlRepo.findAll();
        val allNextNumbers = this.sysPlatformNextNumberRepo.findAll();

        allRules.forEach(rule -> {
            val detailList = allDetails.stream().filter(d -> Objects.equals(d.getRuleId(), rule.getId()))
                    .sorted(Comparator.comparing(SysPlatformNumberRuleDtlDO::getSeq)).collect(Collectors.toList());



        });
    }
}
