package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTmplDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/31
 */
@Repository
public class SysPlatformTmplRepoProc extends BaseRepoProc<SysTmplDO> {

    private static final QSysTmplDO QDO = QSysTmplDO.sysTmplDO;

    public SysPlatformTmplRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }
}
