/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.lang.UUID;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.SysPlatformDataSourceConvert;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformDatabaseSourceDO;
import com.elitescloud.cloudt.platform.service.SysPlatformDatabaseSourceService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformDatabaseSourceRepo;
import com.elitescloud.cloudt.system.datasource.DatabaseConfigDTO;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceQueryParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceSaveParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceUpParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceVO;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysPlatformDatabaseSourceServiceImpl
implements SysPlatformDatabaseSourceService {
    String mysqlDriver = "com.mysql.cj.jdbc.Driver";
    private final SysPlatformDatabaseSourceRepo sysPlatformDatabaseSourceRepo;

    public SysPlatformDatabaseSourceServiceImpl(SysPlatformDatabaseSourceRepo sysPlatformDatabaseSourceRepo) {
        this.sysPlatformDatabaseSourceRepo = sysPlatformDatabaseSourceRepo;
    }

    @Override
    public ApiResult<List<SysPlatformDatabaseSourceVO>> query(SysPlatformDatabaseSourceQueryParam param) {
        Predicate predicate = this.sysPlatformDatabaseSourceRepo.getPredicate(param);
        ArrayList sysPlatformDatabaseSourceVOS = new ArrayList();
        this.sysPlatformDatabaseSourceRepo.findAll(predicate).iterator().forEachRemaining(boFieldDefinitionDo -> {
            SysPlatformDatabaseSourceVO vo = SysPlatformDataSourceConvert.INSTANCE.DoToVo((SysPlatformDatabaseSourceDO)boFieldDefinitionDo);
            sysPlatformDatabaseSourceVOS.add(vo);
        });
        return ApiResult.ok(sysPlatformDatabaseSourceVOS);
    }

    @Override
    public ApiResult<String> queryPasswordById(Long id) {
        SysPlatformDatabaseSourceDO dsDo = this.sysPlatformDatabaseSourceRepo.findById(id).orElse(null);
        if (StringUtils.isEmpty((Object)dsDo)) {
            return ApiResult.fail((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok((Object)dsDo.getDbsPassword());
    }

    @Override
    public ApiResult<SysPlatformDatabaseSourceVO> getById(Long id) {
        SysPlatformDatabaseSourceDO dsDo = this.sysPlatformDatabaseSourceRepo.findById(id).orElse(null);
        if (dsDo == null) {
            return ApiResult.fail((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        SysPlatformDatabaseSourceVO vo = SysPlatformDataSourceConvert.INSTANCE.DoToVo(dsDo);
        return ApiResult.ok((Object)vo);
    }

    @Override
    public ApiResult<SysPlatformDatabaseSourceVO> getByDbsCode(String dbsCode) {
        SysPlatformDatabaseSourceQueryParam param = new SysPlatformDatabaseSourceQueryParam();
        param.setDbsCode(dbsCode);
        Predicate predicate = this.sysPlatformDatabaseSourceRepo.getPredicate(param);
        SysPlatformDatabaseSourceDO dbDo = this.sysPlatformDatabaseSourceRepo.findOne(predicate).orElse(null);
        if (dbDo != null) {
            SysPlatformDatabaseSourceVO vo = SysPlatformDataSourceConvert.INSTANCE.DoToVo(dbDo);
            return ApiResult.ok((Object)vo);
        }
        return ApiResult.fail((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResult<Long> save(SysPlatformDatabaseSourceSaveParam saveVO) {
        SysPlatformDatabaseSourceDO dbDo;
        if (saveVO.getDbsCode() == null || saveVO.getDbsCode().isBlank()) {
            saveVO.setDbsCode(UUID.randomUUID().toString());
        } else {
            dbDo = this.sysPlatformDatabaseSourceRepo.findByDbsCode(saveVO.getDbsCode());
            if (dbDo != null) {
                return ApiResult.fail((String)"\u6570\u636e\u6e90\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        dbDo = SysPlatformDataSourceConvert.INSTANCE.saveVOToDo(saveVO);
        if (dbDo.getDbsDriverClass() == null) {
            dbDo.setDbsDriverClass(this.mysqlDriver);
        }
        this.sysPlatformDatabaseSourceRepo.save(dbDo);
        return ApiResult.ok((Object)dbDo.getId());
    }

    @Override
    public ApiResult<Long> update(Long id, SysPlatformDatabaseSourceUpParam saveVO) {
        SysPlatformDatabaseSourceDO dbDo = this.sysPlatformDatabaseSourceRepo.findById(id).orElse(null);
        if (dbDo != null) {
            if (saveVO.getDbsPassword() == null || saveVO.getDbsPassword().isBlank()) {
                saveVO.setDbsPassword(dbDo.getDbsPassword());
            }
            SysPlatformDataSourceConvert.INSTANCE.saveVOToDo(saveVO, dbDo);
            if (dbDo.getDbsDriverClass() == null) {
                dbDo.setDbsDriverClass(this.mysqlDriver);
            }
            this.sysPlatformDatabaseSourceRepo.save(dbDo);
            return ApiResult.ok((Object)dbDo.getId());
        }
        return ApiResult.fail((String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        this.sysPlatformDatabaseSourceRepo.deleteById(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<String> testConnection(DatabaseConfigDTO config) {
        try {
            DataSource dataSource = this.createDataSource(config);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            jdbcTemplate.execute("SELECT 1");
            return ApiResult.ok((Object)"\u6d4b\u8bd5\u6210\u529f");
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u94fe\u63a5\u5f02\u5e38:" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<String> testConnectionById(Long dbDataSourceId) {
        try {
            SysPlatformDatabaseSourceDO dsDo = this.sysPlatformDatabaseSourceRepo.findById(dbDataSourceId).orElse(null);
            if (dsDo != null) {
                DatabaseConfigDTO config = new DatabaseConfigDTO();
                config.setUrl(dsDo.getDbsUrl());
                config.setUsername(dsDo.getDbsUsername());
                config.setPassword(dsDo.getDbsPassword());
                config.setDriverClass(dsDo.getDbsDriverClass());
                DataSource dataSource = this.createDataSource(config);
                JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
                jdbcTemplate.execute("SELECT 1");
                return ApiResult.ok((Object)"\u6d4b\u8bd5\u6210\u529f");
            }
            return ApiResult.fail((String)("\u6ca1\u6709\u627e\u5230\u6570\u636e\u6e90:" + dbDataSourceId));
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u94fe\u63a5\u5f02\u5e38:" + e.getMessage()));
        }
    }

    private DataSource createDataSource(DatabaseConfigDTO config) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(config.getUrl());
        dataSource.setUsername(config.getUsername());
        dataSource.setPassword(config.getPassword());
        if (config.getDriverClass() == null) {
            dataSource.setDriverClassName(this.mysqlDriver);
        } else {
            dataSource.setDriverClassName(config.getDriverClass());
        }
        return dataSource;
    }
}

