/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.SysPlatformNextNumberConvert;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumPageQueryParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumSaveParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumUpdateParam;
import com.elitescloud.cloudt.platform.model.vo.sequence.SysPlatformSeqNumPageRespVO;
import com.elitescloud.cloudt.platform.model.vo.sequence.SysPlatformSeqNumRespVO;
import com.elitescloud.cloudt.platform.service.SysPlatformSeqNumMngService;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNextNumberRepo;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformNextNumberDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.Expressions;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class SysPlatformSeqNumMngServiceImpl
implements SysPlatformSeqNumMngService {
    private final SysPlatformNextNumberRepo sysPlatformNextNumberRepo;

    @Override
    public ApiResult<Long> update(Long id, SysPlatformSeqNumUpdateParam saveVO) {
        this.sysPlatformNextNumberRepo.findById(id).ifPresentOrElse(sysPlatformNextNumberDO -> {
            sysPlatformNextNumberDO.setName(saveVO.getName());
            sysPlatformNextNumberDO.setStep(saveVO.getStep());
            sysPlatformNextNumberDO.setNextNumber(saveVO.getNextNumber());
            sysPlatformNextNumberDO.setNnPeriod(saveVO.getNnPeriod());
            sysPlatformNextNumberDO.setEnabled(saveVO.getEnabled());
            this.sysPlatformNextNumberRepo.save(sysPlatformNextNumberDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<Long> save(SysPlatformSeqNumSaveParam saveVO) {
        QSysPlatformNextNumberDO qdo = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;
        long countDo = this.sysPlatformNextNumberRepo.count((Predicate)qdo.code.eq((Object)saveVO.getCode()));
        if (countDo != 0L) {
            return ApiResult.fail((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        SysPlatformNextNumberDO sdo = SysPlatformNextNumberConvert.INSTANCE.voToDO(saveVO);
        this.sysPlatformNextNumberRepo.save(sdo);
        return ApiResult.ok((Object)sdo.getId());
    }

    @Override
    public ApiResult<SysPlatformSeqNumRespVO> get(Long id) {
        Optional sdoOp = this.sysPlatformNextNumberRepo.findById(id);
        if (sdoOp.isPresent()) {
            SysPlatformSeqNumRespVO svo = SysPlatformNextNumberConvert.INSTANCE.doToVO((SysPlatformNextNumberDO)sdoOp.get());
            return ApiResult.ok((Object)svo);
        }
        return ApiResult.fail((String)"id\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        this.sysPlatformNextNumberRepo.deleteById(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<Long> switchEnabled(Long id, Boolean enabled) {
        this.sysPlatformNextNumberRepo.findById(id).ifPresentOrElse(sysPlatformNextNumberDO -> {
            sysPlatformNextNumberDO.setEnabled(enabled);
            this.sysPlatformNextNumberRepo.save(sysPlatformNextNumberDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<PagingVO<SysPlatformSeqNumPageRespVO>> page(SysPlatformSeqNumPageQueryParam param) {
        QSysPlatformNextNumberDO qdo = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;
        BooleanTemplate predicate = Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        predicate = StringUtils.isBlank((CharSequence)param.getAppCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qdo.appCode.eq((Object)param.getAppCode()));
        predicate = StringUtils.isBlank((CharSequence)param.getCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qdo.code.eq((Object)param.getCode()));
        PageRequest pageRequest = param.getPageRequest();
        if (pageRequest.getSort().isEmpty()) {
            pageRequest = pageRequest.withSort(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        }
        Page page = this.sysPlatformNextNumberRepo.findAll((Predicate)predicate, (Pageable)pageRequest);
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().map(SysPlatformNextNumberConvert.INSTANCE::doPageToVO).collect(Collectors.toList()));
        return ApiResult.ok((Object)pagingVo);
    }

    public SysPlatformSeqNumMngServiceImpl(SysPlatformNextNumberRepo sysPlatformNextNumberRepo) {
        this.sysPlatformNextNumberRepo = sysPlatformNextNumberRepo;
    }
}

