/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.NextValuePeriod;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformNextNumberDO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumPageQueryParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumSaveParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumUpdateParam;
import com.elitescloud.cloudt.platform.model.vo.sequence.SysPlatformSeqNumPageRespVO;
import com.elitescloud.cloudt.platform.model.vo.sequence.SysPlatformSeqNumRespVO;
import com.elitescloud.cloudt.platform.service.SysPlatformSeqNumMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53d1\u53f7\u5668-\u4e0b\u4e00\u7f16\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/platform/seq/num"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="SysPlatform_NextNumber:\u5e73\u53f0\u4e0b\u4e00\u7f16\u53f7", businessDoClass=SysPlatformNextNumberDO.class)
public class SysPlatformSeqNumMngController {
    public final SysPlatformSeqNumMngService sysPlatformSeqNumMngService;

    public SysPlatformSeqNumMngController(SysPlatformSeqNumMngService sysPlatformSeqNumMngService) {
        this.sysPlatformSeqNumMngService = sysPlatformSeqNumMngService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8bb0\u5f55")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u8bb0\u5f55")
    public ApiResult<PagingVO<SysPlatformSeqNumPageRespVO>> page(@RequestBody SysPlatformSeqNumPageQueryParam queryVO) {
        return this.sysPlatformSeqNumMngService.page(queryVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}/{enabled}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id, @PathVariable(value="enabled") Boolean enabled) {
        return this.sysPlatformSeqNumMngService.switchEnabled(id, enabled);
    }

    @ApiOperation(value="\u5220\u9664\u8bb0\u5f55")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @DeleteMapping(value={"/del/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u8bb0\u5f55", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.sysPlatformSeqNumMngService.delete(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bb0\u5f55\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u8bb0\u5f55\u8be6\u60c5")
    public ApiResult<SysPlatformSeqNumRespVO> get(@PathVariable(value="id") Long id) {
        return this.sysPlatformSeqNumMngService.get(id);
    }

    @ApiOperation(value="\u65b0\u589e\u8bb0\u5f55")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/save"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u65b0\u589e\u8bb0\u5f55", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid SysPlatformSeqNumSaveParam saveVO) {
        return this.sysPlatformSeqNumMngService.save(saveVO);
    }

    @ApiOperation(value="\u4fee\u6539\u8bb0\u5f55")
    @ApiOperationSupport(order=6)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="int")
    @PutMapping(value={"/update/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u4fee\u6539\u8bb0\u5f55", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> update(@PathVariable(value="id") Long id, @RequestBody @Valid SysPlatformSeqNumUpdateParam saveVO) {
        return this.sysPlatformSeqNumMngService.update(id, saveVO);
    }

    @ApiOperation(value="\u7f16\u53f7\u5468\u671f")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/periods"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u7f16\u53f7\u5468\u671f")
    public ApiResult<List<CodeNameParam>> numPeriods() {
        List values = Arrays.stream(NextValuePeriod.values()).map(t -> new CodeNameParam(t.name(), t.getDescription())).collect(Collectors.toList());
        return ApiResult.ok(values);
    }
}

