/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.params.admin.AddAdminMenusParam;
import com.elitescloud.cloudt.platform.model.vo.GetAdminMenusVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAdminMenusService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAdminMenusRepoProc;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepoProc;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysPlatformAdminMenusServiceImpl
implements SysPlatformAdminMenusService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformAdminMenusServiceImpl.class);
    private final SysPlatformAdminMenusRepoProc adminMenusRepoProc;
    private final SysPlatformMenusRepoProc menusRepoProc;
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final SysPlatformAppRepoProc appRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> addAdminMenus(AddAdminMenusParam addParams) {
        List<String> allCodes;
        Assert.notNull((Object)((Object)addParams.getAdminType()), (String)"\u7ba1\u7406\u5458\u7c7b\u578b\u4e3a\u7a7a");
        String adminType = addParams.getAdminType().name();
        ArrayList adminMenus = new ArrayList(128);
        if (CollUtil.isNotEmpty(addParams.getMenusCodeList()) && !(allCodes = this.menusRepoProc.getCodes(null, PlatformAppMenusTypeEnum.MENUS_TYPE_SYS, PlatformMenusNodeEnum.MENUS)).isEmpty()) {
            addParams.getMenusCodeList().stream().filter(allCodes::contains).map(t -> {
                SysPlatformAdminMenusDO adminMenu = new SysPlatformAdminMenusDO();
                adminMenu.setMenusCode((String)t);
                adminMenu.setAdminType(adminType);
                return adminMenu;
            }).forEach(adminMenus::add);
        }
        this.adminMenusRepoProc.deleteByAdminType(adminType);
        if (!adminMenus.isEmpty()) {
            this.adminMenusRepoProc.save(adminMenus);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<GetAdminMenusVO> getAdminMenus(PlatformAdminTypeEnum adminType) {
        Set<String> appCodeList;
        Assert.notNull((Object)((Object)adminType), (String)"\u7ba1\u7406\u5458\u7c7b\u578b\u4e3a\u7a7a");
        List<SysPlatformAppVO> sysPlatformAppVOS = new ArrayList<SysPlatformAppVO>(0);
        List<SysPlatformMenusVO> sysPlatformMenusVOS = this.adminMenusRepoProc.queryMenusByAdminType(adminType).stream().filter(t -> Boolean.TRUE.equals(t.getMenusState())).map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO).collect(Collectors.toList());
        Set<String> set = appCodeList = sysPlatformMenusVOS.isEmpty() ? Collections.emptySet() : sysPlatformMenusVOS.stream().map(SysPlatformMenusVO::getMenusAppCode).collect(Collectors.toSet());
        if (!appCodeList.isEmpty()) {
            sysPlatformAppVOS = this.appRepoProc.listByAppCodes(appCodeList).stream().filter(t -> Boolean.TRUE.equals(t.getAppState())).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO).collect(Collectors.toList());
        }
        GetAdminMenusVO getAdminMenusVO = new GetAdminMenusVO();
        getAdminMenusVO.setAdminType(adminType.name());
        getAdminMenusVO.setAdminTypeName(adminType.getDescription());
        getAdminMenusVO.setSysPlatformAppVOS(sysPlatformAppVOS);
        getAdminMenusVO.setSysPlatformMenusVOS(sysPlatformMenusVOS);
        return ApiResult.ok((Object)getAdminMenusVO);
    }

    public SysPlatformAdminMenusServiceImpl(SysPlatformAdminMenusRepoProc adminMenusRepoProc, SysPlatformMenusRepoProc menusRepoProc, SysPlatformAppRepo sysPlatformAppRepo, SysPlatformAppRepoProc appRepoProc) {
        this.adminMenusRepoProc = adminMenusRepoProc;
        this.menusRepoProc = menusRepoProc;
        this.sysPlatformAppRepo = sysPlatformAppRepo;
        this.appRepoProc = appRepoProc;
    }
}

