package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_menus", description = "平台菜单表")
public class SysPlatformMenusVO extends BaseModel implements Serializable {
    @ApiModelProperty("菜单归属应用")
    private String menusAppCode;

    @ApiModelProperty("菜单名称")
    private String menusName;

    @ApiModelProperty("菜单类型")
    private String menusType;
    @ApiModelProperty("节点类型 菜单,按钮")
    private String nodeType;

    @ApiModelProperty("菜单编码")
    private String menusCode;

    @ApiModelProperty("排序")
    private Integer menusOrder;

    @ApiModelProperty("菜单状态")
    private Boolean menusState;

    @ApiModelProperty("上级菜单编码")
    private String menusParentCode;

    @ApiModelProperty("菜单路由")
    private String menusRoute;

    @ApiModelProperty("描述")
    private String menusDescribe;

    @ApiModelProperty("图标")
    private String menusIcon;

    @ApiModelProperty("是否展示")
    private Boolean display;
    @ApiModelProperty("是否外链接")
    private Boolean outerLink;
    @ApiModelProperty("外链接类型")
    private String outerLinkType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "扩展信息")
    private Map<String, Object> ext;
}
