/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.params.menus.AddButtonParam;
import com.elitescloud.cloudt.platform.model.params.menus.AddFormMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.AddMenusApiParam;
import com.elitescloud.cloudt.platform.model.params.menus.AddMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.DeleteMenusApiParam;
import com.elitescloud.cloudt.platform.model.params.menus.QueryMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.UpdateButtonParam;
import com.elitescloud.cloudt.platform.model.params.menus.UpdateFormMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.UpdateMenusParam;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.MenuOperationDelVO;
import com.elitescloud.cloudt.platform.model.vo.MenuOperationSaveVO;
import com.elitescloud.cloudt.platform.model.vo.MenusAndOperationNumVO;
import com.elitescloud.cloudt.platform.model.vo.MenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuBasicRespVO;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuOperationRespVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@Api(tags={"\u5e73\u53f0\u83dc\u5355\u7ba1\u7406"})
@RequestMapping(value={"/sys/platform/menus"})
@BusinessObject(businessType="SysPlatform_Menus:\u5e73\u53f0\u83dc\u5355", businessDoClass=SysPlatformMenusDO.class)
public class SysPlatformMenusController {
    private final SysPlatformMenusService sysPlatformMenusService;

    public SysPlatformMenusController(SysPlatformMenusService sysPlatformMenusService) {
        this.sysPlatformMenusService = sysPlatformMenusService;
    }

    @PostMapping(value={"/addMenus"})
    @ApiOperation(value="\u6dfb\u52a0\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u83dc\u5355", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addMenus(@RequestBody @Valid AddMenusParam addMenusParam) {
        return this.sysPlatformMenusService.addMenus(addMenusParam);
    }

    @PutMapping(value={"/updateMenus/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u83dc\u5355\u4fe1\u606f", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u83dc\u5355\u4fe1\u606f", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateMenus(@PathVariable Long id, @RequestBody UpdateMenusParam updateMenusParam) {
        return this.sysPlatformMenusService.updateMenus(id, updateMenusParam);
    }

    @PostMapping(value={"/addButton"})
    @ApiOperation(value="\u6dfb\u52a0\u6309\u94ae", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u6309\u94ae", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addButton(@RequestBody @Valid AddButtonParam addButtonParam) {
        return this.sysPlatformMenusService.addButton(addButtonParam);
    }

    @PutMapping(value={"/updateButton/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u6309\u94ae\u4fe1\u606f", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u6309\u94ae\u4fe1\u606f", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateButton(@PathVariable Long id, @RequestBody UpdateButtonParam updateMenusParam) {
        return this.sysPlatformMenusService.updateButton(id, updateMenusParam);
    }

    @PostMapping(value={"/addMenusGroup"})
    @ApiOperation(value="\u6dfb\u52a0\u83dc\u5355\u5206\u7ec4", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u83dc\u5355\u5206\u7ec4", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addMenusGroup(@RequestBody @Valid AddMenusParam addMenusParam) {
        return this.sysPlatformMenusService.addMenusGroup(addMenusParam);
    }

    @PutMapping(value={"/updateMenusGroup/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u83dc\u5355\u5206\u7ec4\u4fe1\u606f", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u83dc\u5355\u5206\u7ec4", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateMenusGroup(@PathVariable Long id, @RequestBody UpdateMenusParam updateMenusParam) {
        return this.sysPlatformMenusService.updateMenusGroup(id, updateMenusParam);
    }

    @PostMapping(value={"/addFormMenus"})
    @ApiOperation(value="\u6dfb\u52a0\u8868\u5355\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u8868\u5355\u83dc\u5355", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addFormMenus(@RequestBody @Valid AddFormMenusParam addMenusParam) {
        return this.sysPlatformMenusService.addFormMenus(addMenusParam);
    }

    @PutMapping(value={"/updateFormMenus/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u8868\u5355\u83dc\u5355", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateFormMenus(@PathVariable Long id, @RequestBody UpdateFormMenusParam updateMenusParam) {
        return this.sysPlatformMenusService.updateFormMenus(id, updateMenusParam);
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @PutMapping(value={"/deleteFlagMenus/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u83dc\u5355", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> deleteFlagMenus(@PathVariable Long id) {
        return this.sysPlatformMenusService.deleteMenus(id);
    }

    @PutMapping(value={"/updateMenusState/{id}/{state}"})
    @ApiOperation(value="\u66f4\u65b0\u83dc\u5355\u662f\u5426\u542f\u7528\u72b6\u6001", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u542f\u7528\u72b6\u6001", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateMenusState(@PathVariable Long id, @PathVariable Boolean state) {
        return this.sysPlatformMenusService.updateMenusState(id, state);
    }

    @GetMapping(value={"/getMenus/{id}"})
    @ApiOperation(value="id\u67e5\u8be2\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2\u83dc\u5355")
    public ApiResult<SysPlatformMenusVO> getMenus(@PathVariable Long id) {
        return this.sysPlatformMenusService.getMenus(id);
    }

    @GetMapping(value={"/getSysAppMenus"})
    @ApiOperation(value="\u8fd4\u56de\u7cfb\u7edf\u5e94\u7528\u548c\u7cfb\u7edf\u83dc\u5355\u6570\u636e-\u72b6\u6001\u90fd\u662f\u542f\u7528", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u7cfb\u7edf\u83dc\u5355\u542f\u7528\u6570\u636e")
    public ApiResult<GetAppMenusVO> getSysAppMenus() {
        return this.sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }

    @GetMapping(value={"/getBusAppMenus"})
    @ApiOperation(value="\u8fd4\u56de\u4e1a\u52a1\u5e94\u7528\u548c\u4e1a\u52a1\u83dc\u5355\u6570\u636e-\u72b6\u6001\u90fd\u662f\u542f\u7528", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u4e1a\u52a1\u83dc\u5355\u542f\u7528\u6570\u636e")
    public ApiResult<GetAppMenusVO> getBusAppMenus() {
        return this.sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
    }

    @GetMapping(value={"/getSysAppMenusAll"})
    @ApiOperation(value="\u8fd4\u56de\u7cfb\u7edf\u5e94\u7528\u7684\u7cfb\u7edf\u83dc\u5355\u6570\u636e-\u72b6\u6001\u542f\u7528\u548c\u975e\u542f\u7528", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u7cfb\u7edf\u5e94\u7528\u7684\u7cfb\u7edf\u83dc\u5355")
    public ApiResult<GetAppMenusVO> getSysAppMenusAll() {
        return this.sysPlatformMenusService.getSysAppMenusAll(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }

    @GetMapping(value={"/getBusAppMenusAll"})
    @ApiOperation(value="\u8fd4\u56de\u4e1a\u52a1\u5e94\u7528\u548c\u4e1a\u52a1\u83dc\u5355\u6570\u636e-\u72b6\u6001\u542f\u7528\u548c\u975e\u542f\u7528", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u4e1a\u52a1\u5e94\u7528\u548c\u4e1a\u52a1\u83dc\u5355")
    public ApiResult<GetAppMenusVO> getBusAppMenusAll() {
        return this.sysPlatformMenusService.getSysAppMenusAll(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
    }

    @GetMapping(value={"/getAllAppMenus"})
    @ApiOperation(value="\u8fd4\u56de\u5168\u90e8\u5e94\u7528\u548c\u83dc\u5355-\u72b6\u6001\u542f\u7528\u548c\u975e\u542f\u7528", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u8fd4\u56de\u5168\u90e8\u5e94\u7528\u548c\u83dc\u5355")
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        return this.sysPlatformMenusService.getAllAppMenus();
    }

    @PostMapping(value={"/queryMenus"})
    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2\u83dc\u5355")
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(@RequestBody @Valid QueryMenusParam queryMenusParam) {
        return this.sysPlatformMenusService.queryMenus(queryMenusParam);
    }

    @GetMapping(value={"/enum/getMenusTypeEnum"})
    @ApiOperation(value="\u83dc\u5355\u7c7b\u578b\u679a\u4e3e", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83dc\u5355\u7c7b\u578b\u679a\u4e3e")
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
        return this.sysPlatformMenusService.getMenusTypeEnum();
    }

    @GetMapping(value={"/enum/getPlatformMenusOuterLinkTypeEnum"})
    @ApiOperation(value="\u83dc\u5355\u5916\u94fe\u7c7b\u578b\u679a\u4e3e", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83dc\u5355\u5916\u94fe\u7c7b\u578b\u679a\u4e3e")
    public ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum() {
        return this.sysPlatformMenusService.getPlatformMenusOuterLinkTypeEnum();
    }

    @GetMapping(value={"/getAllAppMenusApi/{appCode}"})
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u67e5\u8be2\u5e94\u7528\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2\u5e94\u7528\u83dc\u5355")
    @ApiIgnore
    @Deprecated(since="3.3.0")
    public ApiResult<List<MenusAndOperationNumVO>> getAllAppMenusApi(@PathVariable String appCode) {
        return this.sysPlatformMenusService.getAllAppMenusApi(appCode);
    }

    @PostMapping(value={"/api/add"})
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u6dfb\u52a0\u83dc\u5355\u6302\u8f7dAPI\u63a5\u53e3", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u83dc\u5355\u6302\u8f7dAPI", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    @ApiIgnore
    @Deprecated(since="3.3.0")
    public ApiResult<Boolean> addMenusApi(@RequestBody AddMenusApiParam addMenusApiParam) {
        return this.sysPlatformMenusService.addMenusApi(addMenusApiParam);
    }

    @PutMapping(value={"/deleteMenusApi"})
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u5220\u9664\u83dc\u5355\u6302\u8f7dAPI\u63a5\u53e3", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u83dc\u5355\u6302\u8f7dAPI", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    @ApiIgnore
    @Deprecated(since="3.3.0")
    public ApiResult<Boolean> deleteMenusApi(@RequestBody DeleteMenusApiParam deleteMenusApiParam) {
        return this.sysPlatformMenusService.deleteMenusApi(deleteMenusApiParam);
    }

    @PostMapping(value={"/api/{appId}/{menusId}"})
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u67e5\u8be2\u83dc\u5355\u6302\u8f7dAPI\u63a5\u53e3", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2\u83dc\u5355\u6302\u8f7dAPI")
    @ApiIgnore
    @Deprecated(since="3.3.0")
    public ApiResult<List<MenusApiVO>> getMenusApis(@PathVariable Long appId, @PathVariable Long menusId) {
        return this.sysPlatformMenusService.getMenusApis(appId, menusId);
    }

    @GetMapping(value={"/getAllAppMenusApi/{appCode}/v1"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u83dc\u5355", notes="\u5e73\u53f0\u83dc\u5355\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2\u5e94\u7528\u83dc\u5355")
    public ApiResult<List<MenusAndOperationNumVO>> listMenuByApp(@PathVariable String appCode) {
        return this.sysPlatformMenusService.listMenusByAppCode(appCode);
    }

    @PostMapping(value={"/operation"})
    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u6302\u8f7d\u7684\u64cd\u4f5c")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u83dc\u5355\u6302\u8f7d\u64cd\u4f5c", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> saveMenuOperation(@Valid @RequestBody MenuOperationSaveVO saveVO) {
        return this.sysPlatformMenusService.saveMenuOperation(saveVO);
    }

    @DeleteMapping(value={"/operation"})
    @ApiOperation(value="\u5220\u9664\u83dc\u5355\u6302\u8f7d\u7684\u64cd\u4f5c")
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u83dc\u5355\u6302\u8f7d\u64cd\u4f5c", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> delMenuOperation(@Valid @RequestBody MenuOperationDelVO delVO) {
        return this.sysPlatformMenusService.deleteMenuOperation(delVO);
    }

    @GetMapping(value={"/operation"})
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u6302\u8f7d\u7684\u64cd\u4f5c")
    @ApiImplicitParam(name="menuCode", value="\u83dc\u5355\u7f16\u7801", required=true, dataType="String")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u83dc\u5355\u6302\u8f7d\u64cd\u4f5c", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<List<MenuOperationRespVO>> listMenuOperation(@NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") @RequestParam(name="menuCode") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") String menuCode) {
        return this.sysPlatformMenusService.listMenuOperation(menuCode);
    }

    @GetMapping(value={"/operation/menus"})
    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u5173\u8054\u7684\u83dc\u5355")
    @ApiImplicitParam(name="operationCode", value="\u64cd\u4f5c\u7f16\u7801", required=true, dataType="String")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u64cd\u4f5c\u5173\u8054\u7684\u83dc\u5355", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<List<MenuBasicRespVO>> listMenuOfOperation(@NotBlank(message="\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a") @RequestParam(name="operationCode") @NotBlank(message="\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a") String operationCode) {
        return this.sysPlatformMenusService.listMenuOfOperation(operationCode);
    }
}

