package com.elitescloud.cloudt.platform.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/9 10:53
 */

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 数据源表;
 * @author : http://www.chiner.pro
 * @date : 2023-10-9
 */
@Entity
@ApiModel(value = "数据源表",description = "")
@Table(name="sys_platform_database_source")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_database_source", comment = "数据源表")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysPlatformDatabaseSourceDO extends BaseModel implements Serializable{
    @ApiModelProperty(name = "数据源标识",notes = "")
    @Comment("数据源标识")
    @Column(nullable = false)
    private String dbsCode ;
    @ApiModelProperty(name = "数据源名称",notes = "")
    @Comment("数据源名称")
    @Column(nullable = false)
    private String dbsType ;
    /** 数据源名称 */
    @ApiModelProperty(name = "数据源名称",notes = "")
    @Comment("数据源名称")
    @Column(nullable = false)
    private String dbsName;
    @ApiModelProperty(name = "描述",notes = "")
    @Comment("描述")
    @Column(nullable = false)
    private String dbsDescription ;
    @ApiModelProperty(name = "IP/主机名",notes = "")
    @Comment("IP/主机名")
    @Column(nullable = false)
    private String dbsHostname ;
    @ApiModelProperty(name = "数据库端口",notes = "")
    @Comment("数据库端口")
    @Column(nullable = false)
    private String dbsDbPort;
    @ApiModelProperty(name = "jdbc额外参数",notes = "")
    @Comment("jdbc额外参数")
    @Column(nullable = false)
    private String jdbcExtraParameters;
    @ApiModelProperty(name = "URL",notes = "")
    @Comment("URL")
    @Column(nullable = false)
    private String dbsUrl ;
    @ApiModelProperty(name = "默认数据库名",notes = "")
    @Comment("默认数据库名")
    @Column(nullable = false)
    private String dbsDbName ;
    @ApiModelProperty(name = "驱动类",notes = "")
    @Comment("驱动类")
    @Column(nullable = false)
    private String dbsDriverClass ;
    @ApiModelProperty(name = "账号名称",notes = "")
    @Comment("账号名称")
    @Column(nullable = false)
    private String dbsUsername ;
    @ApiModelProperty(name = "数据库密码",notes = "")
    @Comment("数据库密码")
    @Column(nullable = false)
    private String dbsPassword ;
    @ApiModelProperty(name = "Schema",notes = "")
    @Comment("Schema")
    @Column(nullable = false)
    private String dbsSchema ;
    @ApiModelProperty(name = "链接方式 如oracle SID/服务名",notes = "")
    @Comment("链接方式 如oracle SID/服务名")
    @Column(nullable = false)
    private String dbsLinkMode;

}
