package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.*;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuBasicRespVO;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuOperationRespVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
public interface SysPlatformMenusService {
    ApiResult<Long> addMenus(AddMenusParam addMenusParam);

    ApiResult<Long> addButton(AddButtonParam addButtonParam);

    ApiResult<Boolean> updateMenus(Long id, UpdateMenusParam updateMenusParam);

    ApiResult<Boolean> updateButton(Long id, UpdateButtonParam updateMenusParam);

    ApiResult<Boolean> deleteFlagMenus(Long id);

    ApiResult<Boolean> updateMenusState(Long id, Boolean state);

    ApiResult<SysPlatformMenusVO> getMenus(Long id);

    ApiResult<List<SysPlatformMenusVO>> queryMenus(QueryMenusParam queryMenusParam);

    ApiResult<List<SysUdcVO>> getMenusTypeEnum();


    ApiResult<Long> addMenusGroup(AddMenusParam addMenusParam);

    ApiResult<Boolean> updateMenusGroup(Long id, UpdateMenusParam updateMenusParam);


    /**
     * 查询 应用信息和 菜单信息 只能查询系统类型或业务类型
     **/
    ApiResult<GetAppMenusVO> getSysBusAppMenus(PlatformAppMenusTypeEnum platformAppMenusTypeEnum);

    /**
     * 查询全部类型应用和菜单
     **/
    ApiResult<GetAppMenusVO> getAllAppMenus();

    ApiResult<GetAppMenusVO> getSysAppMenusAll(PlatformAppMenusTypeEnum menusTypeSys);

    ApiResult<Boolean> deleteMenus(Long id);

    ApiResult<Long> addFormMenus(AddFormMenusParam addMenusParam);

    ApiResult<Boolean> updateFormMenus(Long id, UpdateFormMenusParam updateMenusParam);

    ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum();

    /**
     * 根据应用编码获取菜单
     *
     * @param appCode 应用编码
     * @return 菜单列表
     * @deprecated 请使用 {@link #listMenusByAppCode(String)}
     */
    @Deprecated(since = "3.3.0")
    ApiResult<List<MenusAndOperationNumVO>> getAllAppMenusApi(String appCode);

    /**
     * 根据应用编码获取菜单
     *
     * @param appCode 应用编码
     * @return 菜单列表
     */
    ApiResult<List<MenusAndOperationNumVO>> listMenusByAppCode(String appCode);

    @Deprecated(since = "3.3.0")
    ApiResult<Boolean> addMenusApi(AddMenusApiParam addMenusApiParam);

    @Deprecated(since = "3.3.0")
    ApiResult<Boolean> deleteMenusApi(DeleteMenusApiParam deleteMenusApiParam);

    @Deprecated(since = "3.3.0")
    ApiResult<List<MenusApiVO>> getMenusApis(Long appId, Long menusId);

    /**
     * 保存菜单挂载的操作
     *
     * @param saveVO 操作信息
     * @return 操作结果
     */
    ApiResult<Boolean> saveMenuOperation(MenuOperationSaveVO saveVO);

    /**
     * 删除菜单挂载的操作
     *
     * @param delVO 操作信息
     * @return 操作结果
     */
    ApiResult<Boolean> deleteMenuOperation(MenuOperationDelVO delVO);

    /**
     * 获取菜单挂载的操作
     *
     * @param menuCode 菜单编码
     * @return 操作列表
     */
    ApiResult<List<MenuOperationRespVO>> listMenuOperation(String menuCode);

    /**
     * 获取业务操作关联的菜单
     *
     * @param operationCode 操作编码
     * @return 菜单信息
     */
    ApiResult<List<MenuBasicRespVO>> listMenuOfOperation(String operationCode);
}
