package com.elitescloud.cloudt.platform.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Set;

/**
 * 保存菜单与操作绑定信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
@Getter
@Setter
@ApiModel(description = "保存菜单与操作绑定信息")
public class MenuOperationSaveVO implements Serializable {
    private static final long serialVersionUID = 6289681889757832249L;

    @ApiModelProperty(value = "菜单编码", required = true, position = 1)
    @NotBlank(message = "菜单编码为空")
    private String menuCode;

    @ApiModelProperty(value = "是否增量")
    private Boolean incremental;

    @ApiModelProperty(value = "操作编码", position = 2)
    private Set<String> operationCodes;
}
