/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.ApiPermissionConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiPermissionDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiPermissionDO;
import com.elitescloud.cloudt.platform.model.params.api.AddApiPermissionParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformApiPermissionVO;
import com.elitescloud.cloudt.platform.service.SysPlatformApiPermissionService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformApiPermissionRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepoProc;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysPlatformApiPermissionServiceImpl
implements SysPlatformApiPermissionService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformApiPermissionServiceImpl.class);
    private final SysPlatformApiPermissionRepo sysPlatformApiPermissionRepo;
    private final SysPlatformMenusRepoProc menusRepoProc;

    @Override
    public ApiResult<List<SysPlatformApiPermissionVO>> getApiPermission(String menusCode) {
        List<SysPlatformApiPermissionDO> listDO = this.sysPlatformApiPermissionRepo.findAllByMenusCode(menusCode);
        return ApiResult.ok(listDO.stream().map(ApiPermissionConvert.INSTANCE::sysPlatformDOToSysPlatformVO).collect(Collectors.toList()));
    }

    @Override
    public ApiResult<Boolean> deleteApiPermission(Long id) {
        this.sysPlatformApiPermissionRepo.deleteById(id);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Long> addApiPermission(AddApiPermissionParam addApiPermission) {
        QSysPlatformApiPermissionDO qdo = QSysPlatformApiPermissionDO.sysPlatformApiPermissionDO;
        long apiCount = this.sysPlatformApiPermissionRepo.count((Predicate)qdo.permissonCode.eq((Object)addApiPermission.getPermissonCode()));
        if (apiCount != 0L) {
            return ApiResult.fail((String)"\u6743\u9650\u7f16\u7801\u91cd\u590d");
        }
        SysPlatformApiPermissionDO apiDo = ApiPermissionConvert.INSTANCE.saveParamToDo(addApiPermission);
        if (StringUtils.hasText((String)addApiPermission.getMenusCode())) {
            String appCode = this.menusRepoProc.getAppCode(addApiPermission.getMenusCode());
            apiDo.setAppCode(appCode);
        }
        return ApiResult.ok((Object)((SysPlatformApiPermissionDO)this.sysPlatformApiPermissionRepo.save(apiDo)).getId());
    }

    public SysPlatformApiPermissionServiceImpl(SysPlatformApiPermissionRepo sysPlatformApiPermissionRepo, SysPlatformMenusRepoProc menusRepoProc) {
        this.sysPlatformApiPermissionRepo = sysPlatformApiPermissionRepo;
        this.menusRepoProc = menusRepoProc;
    }
}

