/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.SysPlatformNumberRuleConvert;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleAddParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleQParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleVO;
import com.elitescloud.cloudt.platform.service.ISysPlatformNumberRuleDtlService;
import com.elitescloud.cloudt.platform.service.ISysPlatformNumberRuleService;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleRepo;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleRepoProc;
import com.elitescloud.cloudt.system.config.TenantProperties;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ISysPlatformNumberRuleServiceImpl
extends BaseServiceImpl
implements ISysPlatformNumberRuleService {
    private static final Logger log = LogManager.getLogger(ISysPlatformNumberRuleServiceImpl.class);
    private static final SysPlatformNumberRuleConvert CONVERT = SysPlatformNumberRuleConvert.INSTANCE;
    @Autowired
    private SysPlatformNumberRuleRepo sysPlatformNumberRuleRepo;
    @Autowired
    private SysPlatformNumberRuleRepoProc sysPlatformNumberRuleRepoProc;
    @Autowired
    private ISysPlatformNumberRuleDtlService sysNumberRuleDtlService;
    @Autowired
    private SysTenantBasicDataService tenantBasicDataService;
    @Autowired(required=false)
    private TenantProperties tenantProperties;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> create(SysPlatformNumberRuleAddParam rule) {
        boolean exists = this.sysPlatformNumberRuleRepoProc.existsRuleCode(rule.getRuleCode());
        if (exists) {
            return ApiResult.fail((String)("\u7f16\u53f7\u89c4\u5219\uff1a" + rule.getRuleCode() + "\uff0c \u5df2\u7ecf\u5b58\u5728"));
        }
        SysPlatformNumberRuleDO ruleDO = CONVERT.voToDO(rule);
        if (ruleDO.getEnabled() == null) {
            ruleDO.setEnabled(Boolean.valueOf(true));
        }
        ruleDO.setTenantCustom(Boolean.valueOf(false));
        this.sysPlatformNumberRuleRepo.save(ruleDO);
        this.syncToTenant(rule.getAppCode(), rule.getRuleCode());
        return ApiResult.ok((Object)ruleDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(SysPlatformNumberRuleAddParam rule) {
        if (rule.getId() == null) {
            return ApiResult.fail((String)"\u6570\u636e\u6807\u8bc6ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDO numberRuleDO = (SysPlatformNumberRuleDO)this.sysPlatformNumberRuleRepoProc.get(rule.getId());
        if (numberRuleDO == null) {
            return ApiResult.fail((String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        boolean exists = this.sysPlatformNumberRuleRepoProc.existsRuleCode(rule.getRuleCode(), rule.getId());
        if (exists) {
            return ApiResult.fail((String)("\u7f16\u53f7\u89c4\u5219\uff1a" + rule.getRuleCode() + "\uff0c \u5df2\u7ecf\u5b58\u5728"));
        }
        CONVERT.copyAddVoToDO(rule, numberRuleDO);
        if (numberRuleDO.getEnabled() == null) {
            numberRuleDO.setEnabled(Boolean.valueOf(true));
        }
        this.sysPlatformNumberRuleRepo.save(numberRuleDO);
        this.syncToTenant(rule.getAppCode(), rule.getRuleCode());
        return ApiResult.ok((Object)numberRuleDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDO numberRuleDO = (SysPlatformNumberRuleDO)this.sysPlatformNumberRuleRepoProc.get(id);
        if (numberRuleDO == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        Boolean enabled = numberRuleDO.getEnabled();
        enabled = enabled == null || enabled == false;
        this.sysPlatformNumberRuleRepoProc.updateEnabled(id, enabled);
        this.syncToTenant(numberRuleDO.getAppCode(), numberRuleDO.getRuleCode());
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> removeById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDO numberRuleDO = (SysPlatformNumberRuleDO)this.sysPlatformNumberRuleRepoProc.get(id);
        if (numberRuleDO == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        this.sysPlatformNumberRuleRepoProc.delete(id);
        this.syncToTenant(numberRuleDO.getAppCode(), numberRuleDO.getRuleCode());
        return ApiResult.ok((Object)true);
    }

    @Override
    @SysCodeProc
    public ApiResult<PagingVO<SysPlatformNumberRuleVO>> search(SysPlatformNumberRuleQParam param) {
        PagingVO pageResult = this.sysPlatformNumberRuleRepoProc.queryForPage(param).map(CONVERT::doToVO);
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<String> generateSampleCode(Long ruleId, List<String> runtimeValues) {
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> generateSampleCode(String ruleCode, List<String> runtimeValues) {
        if (!StringUtils.hasText((String)ruleCode)) {
            return ApiResult.fail((String)"\u7f16\u53f7\u4e3a\u7a7a");
        }
        Long id = this.sysPlatformNumberRuleRepoProc.getIdByCode(ruleCode);
        if (id == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u53d1\u53f7\u89c4\u5219[" + ruleCode + "]");
        }
        return this.generateSampleCode(id, runtimeValues);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> generateCode(Long ruleId, List<String> runtimeValues) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> generateCode(String ruleCode, List<String> runtimeValues) {
        Long id = this.sysPlatformNumberRuleRepoProc.getIdByCode(ruleCode);
        if (id == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u53d1\u53f7\u89c4\u5219[" + ruleCode + "]");
        }
        return this.generateCode(id, runtimeValues);
    }

    @Override
    public ApiResult<SysPlatformNumberRuleVO> oneCombined(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDO numberRule = (SysPlatformNumberRuleDO)this.sysPlatformNumberRuleRepoProc.get(id);
        if (numberRule == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SysPlatformNumberRuleVO ruleVO = CONVERT.doToVO(numberRule);
        List details = (List)this.sysNumberRuleDtlService.listByRuleId(id).getData();
        ruleVO.setRuleDetails((List)ObjectUtil.defaultIfNull((Object)details, Collections.emptyList()));
        return ApiResult.ok((Object)ruleVO);
    }

    private String preZero(long val, int len) {
        String format = "%0" + len + "d";
        return String.format(format, val);
    }

    private void syncToTenant(String appCode, String ruleCode) {
        if (this.tenantProperties == null || Boolean.FALSE.equals(this.tenantProperties.isAutoSyncBasicData())) {
            return;
        }
        this.taskExecutor.execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tenantBasicDataService.syncSequence(appCode, ruleCode);
        });
    }
}

