package com.elitescloud.cloudt.comm.service;

import com.elitescloud.cloudt.comm.vo.param.ComDistrictQueryParamVO;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.comm.vo.resp.ComDistrictComboVO;
import com.elitescloud.cloudt.comm.vo.resp.ComDistrictRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 省地区服务接口
 *
 * @author Mir
 * @date 2020/7/31
 */
@FeignClient(name = Application.NAME, path = ComDistrictProviderService.URI)
@Validated
public interface ComDistrictProviderService {
    String URI = Application.URI_PREFIX + "/district";

    @PostMapping(value = "/search")
    PagingVO<ComDistrictRespVO> search(@RequestBody ComDistrictQueryParamVO param);

    @GetMapping(value = "/listByPId")
    List<ComDistrictRespVO> listByPId(@RequestParam(value = "pId") @NotNull(message = "pId为空") Long pId);

    @GetMapping(value = "/listByPCode")
    List<ComDistrictComboVO> listByPCode(@RequestParam(value = "pCode") @NotNull(message = "pCode为空") String pCode);

    @GetMapping(value = "/listByPCode2")
    List<ComDistrictComboVO> listByPCode2(@RequestParam(value = "pCode") @NotNull(message = "pCode为空") String pCode);

    @GetMapping(value = "/listByDistLevelNum")
    List<ComDistrictComboVO> listByDistLevelNum(@RequestParam(value = "distLevelNum") @NotNull(message = "distLevelNum为空") Integer distLevelNum);

    @GetMapping(value = "/getById")
    ComDistrictRespVO getById(@RequestParam(value = "id") @NotNull(message = "id为空") Long id);

    @PostMapping(value = "/getByDistCodes")
    List<ComDistrictComboVO> getByDistCodes(@RequestBody List<String> distCodes);

    @PostMapping(value = "/getCityByDistCodes")
    List<ComDistrictComboVO> getCityByDistCodes(@RequestBody List<String> distCodes,
                                                @RequestParam(name = "distLevelNum") @NotNull(message = "distLevelNum为空") String distLevelNum);

}
