package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysFlowRoleDTO;
import com.elitescloud.cloudt.system.provider.dto.SysUserFlowRoleDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 流程角色.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/05
 */
@FeignClient(name = Application.NAME, path = SysFlowRoleService.URI)
@Validated
public interface SysFlowRoleService {
    String URI = Application.URI_PREFIX + "/flowRole";

    /**
     * 根据流程角色ID获取流程角色信息
     *
     * @param id 流程角色ID
     * @return 流程角色信息
     */
    @GetMapping(value = "/getById")
    ApiResult<SysFlowRoleDTO> get(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id);

    /**
     * 根据流程角色ID获取流程角色信息
     *
     * @param ids 流程角色ID
     * @return 流程角色信息
     */
    @PostMapping(value = "/getByIds")
    ApiResult<List<SysFlowRoleDTO>> get(@RequestBody @NotEmpty(message = "ID为空") List<Long> ids);

    /**
     * 根据流程角色编码获取流程角色信息
     *
     * @param code 流程角色编码
     * @return 流程角色信息
     */
    @GetMapping(value = "/getByCode")
    ApiResult<SysFlowRoleDTO> getByCode(@RequestParam(value = "code") @NotBlank(message = "编号为空") String code);

    /**
     * 根据流程角色编码获取流程角色信息
     *
     * @param codes 流程角色编码
     * @return 流程角色信息
     */
    @PostMapping(value = "/getByCodes")
    ApiResult<List<SysFlowRoleDTO>> getByCode(@RequestBody @NotEmpty(message = "编号为空") List<String> codes);

    /**
     * 获取用户绑定的流程角色信息
     *
     * @param userId 用户ID
     * @return 流程角色信息
     */
    @GetMapping(value = "/getByUserId")
    ApiResult<List<SysFlowRoleDTO>> getByUserId(@RequestParam(value = "userId") @NotNull(message = "用户ID为空") Long userId);

    /**
     * 获取用户绑定的流程角色信息
     *
     * @param userIds 用户ID
     * @return 流程角色信息
     */
    @PostMapping(value = "/getByUserIds")
    ApiResult<List<SysUserFlowRoleDTO>> getByUserId(@RequestBody @NotEmpty(message = "用户ID为空") List<Long> userIds);
}
