package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.param.SysNextNumberQParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysNextNumberVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 下一编号
 *
 * @author Michael Li
 * @date 2020-10-12
 */
@FeignClient(name = Application.NAME, path = SysNextNumberService.URI)
@Validated
public interface SysNextNumberService {
    String URI = Application.URI_PREFIX + "/nextNumber";

    /**
     * 根据code获取下一编号值
     *
     * @param code 下一编号定义code
     * @return 下一编号的值
     */
    @GetMapping(value = "/getNextNumber")
    Long getNextNumber(@RequestParam(value = "code") @NotBlank(message = "编号为空") String code,
                       @RequestParam(value = "nnLen")  @NotNull(message = "编号长度为空") Integer nnLen);

    @GetMapping(value = "/getNextNumberForRuntime")
    Long getNextNumberForRuntime(@RequestParam(value = "code") @NotBlank(message = "编号为空") String code,
                                 @RequestParam(value = "nnLen") @NotNull(message = "编号长度为空") Integer nnLen);

    /**
     * 检索系统下一编号配置
     *
     * @param param 查询条件对象
     * @return 分页的系统下一编号对象列表
     */
    @PostMapping(value = "/search")
    PagingVO<SysNextNumberVO> search(@RequestBody SysNextNumberQParam param);
}
