package com.elitescloud.cloudt.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 功能说明
 * </p >
 *
 * @author niu.chen
 * @date 2021-07-07
 */
@Data
@ApiModel("角色查询结果对象")
public class SysDataRoleVO implements Serializable {

    private static final long serialVersionUID = 2550082155696670245L;

    @ApiModelProperty("角色ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "角色代码")
    private String code;

    @ApiModelProperty(value = "角色名称")
    private String name;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "是否启用高级授权, 默认false")
    private Boolean advancedEnable;
    @ApiModelProperty(value = "是否启用业务授权, 默认false")
    private Boolean businessEnable;

    @ApiModelProperty("当前用户的基础数据权限对象清单")
    private SysDataAuthVO sysDataAuthVO;

    @ApiModelProperty("当前用户的高级授权应用数据权限对象 应用code")
    private Map<String , SysDataAuthVO> stringSysDataPermissionVOMap;

    @ApiModelProperty("当前用户数据角色的业务数据权限集合")
    private List<SysBizDataConstraintVO> sysBizDataConstraintVO;
}
