package com.elitescloud.cloudt.system.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 下一编号
 */
@Data
@ApiModel("系统下一编号VO")
public class SysNextNumberVO implements Serializable {

    private static final long serialVersionUID = -8322372860111529382L;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    private Long id;

    /**
     * 下一编号代码
     */
    @ApiModelProperty(value = "下一编号代码")
    @NotBlank(message = "下一编号代码为空")
    private String code;

    /**
     * 下一编号名称
     */
    @ApiModelProperty(value = "下一编号名称")
    @NotBlank(message = "下一编号名称码为空")
    private String name;

    /**
     * 下一编号分类
     */
    @ApiModelProperty(value = "下一编号分类")
    private String numberClass;

    /**
     * 下一编号步长
     */
    @ApiModelProperty(value = "下一编号步长")
    private Integer step;

    /**
     * 下一编号取值
     */
    @ApiModelProperty(value = "下一编号取值")
    private Long nextNumber;

    /**
     * 下一编号周期[UDC]SYS:NNPERIOD
     */
    @ApiModelProperty(value = "下一编号周期[UDC]SYS:NNPERIOD")
    private String nnPeriod;

    /**
     * 下一编号周期名称
     */
    @ApiModelProperty(value = "下一编号周期名称")
    private String nnPeriodName;

    /**
     * 发号时间
     */
    @ApiModelProperty(value = "发号时间")
    private LocalDateTime nnTime;
}
