package com.elitescloud.cloudt.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 *  用于获取权限及角色数据
 * <p>
 *
 * @author Roman.Zhang
 * @date 2021/4/27
 */
@Data
@ApiModel(value = "权限角色信息", description = "权限角色信息")
public class SysPermissionRoleVO implements Serializable {
    private static final long serialVersionUID = -8210141983122490888L;

    @ApiModelProperty("权限ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "URL路径模式")
    @NotBlank(message = "URL路径不能为空")
    private String pattern;

    @ApiModelProperty(value = "URL的HTTP方法[COM:HTTP_METH]")
    String httpMethod;

    @ApiModelProperty("角色信息")
    String roleCode;

    @ApiModelProperty("角色信息集合")
    List<String> roleCodeList;
}
