package com.elitescloud.cloudt.system.vo;

import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Michael Li
 */
@Data
@Accessors(chain = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserDTO implements Serializable {

    private static final long serialVersionUID = -307368107814607072L;

    /**
     * 加上：@JsonSerialize(using = ToStringSerializer.class)并不能把long转为字符串，
     * 目前通过SysUserDTO转为SysUserVO
     */
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;

    /**
     * 所属公司ID
     */
    private Long ouId;

    /**
     * 公司编码
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId ;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime ;

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId ;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty(value = "用户账号名称")
    private String username;

    @ApiModelProperty(value = "用户姓氏")
    private String lastName;

    @ApiModelProperty(value = "用户名称")
    private String firstName;

    @ApiModelProperty(value = "用户手机号码")
    private String mobile;

    @ApiModelProperty(value = "用户邮箱地址")
    private String email;

    @ApiModelProperty(value = "用户账号密码-hashed")
    private String password;

    @ApiModelProperty(value = "微信openid")
    private String wxOpenid;
    /**
     * <Strong>Mir 2020-09-15 增加账号信息来源字段，默认sys，由系统创建</Strong>
     */
    @ApiModelProperty("账号来源, sys： 系统创建；wec：微信创建；oth：其他方式")
    private String sourceType;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "是否需要重置")
    private Boolean needReset;

    @ApiModelProperty(value = "是否同步 0 未同步 1 已同步")
    private Integer transFlag;

    @ApiModelProperty("当前用户的角色对象清单")
    private Set<SysRoleVO> roles = Collections.emptySet();

    @ApiModelProperty("当前用户的权限清单")
    private Map<Long, Set<SysPermissionVO>> permissions = Collections.emptyMap();

    @ApiModelProperty("当前用户的数据角色对象清单")
    private Set<SysDataRoleVO> sysDataRoleVOS = Collections.emptySet();

    /**
     * 用户头像地址
     */
    private String avatarUrl;

    /**
     * 用户头像的文件编码
     */
    private String avatarCode;

    /**
     * 用户的终端
     */
    private List<Terminal> terminals = Collections.emptyList();

    /**
     * 用户当前的租户
     */
    private SysTenantDTO sysTenantVO;

    /**
     * 用户所有的租户
     */
    private List<SysTenantDTO> sysTenantDTOList = Collections.emptyList();

    public Long getTenantId() {
        if (sysTenantVO != null) {
            return sysTenantVO.getId();
        }
        return tenantId;
    }
}
