package com.elitescloud.cloudt.comm.service;

import com.elitescloud.cloudt.comm.consumer.dto.ComCurrRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.comm.vo.ComCurrVO;
import com.elitescloud.cloudt.comm.vo.param.ComCurrQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComCurrRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 币种服务接口
 *
 * @author Chris
 * @date 2021-03-25
 */
@FeignClient(name = Application.NAME, path = ComCurrProviderService.URI)
@Validated
public interface ComCurrProviderService {
    String URI = Application.URI_PREFIX + "/curr";

    /**
     * 获取全部币种信息
     *
     * @return 币种信息
     */
    @GetMapping(value = "/findAllVos")
    List<ComCurrVO> findAllVos();

    /**
     * 根据货币code查询货币
     *
     * @param currList code
     * @return 货币
     */
    @PostMapping(value = "/findByCodes")
    List<ComCurrRespVO> findByCodes(@RequestBody List<String> currList);

    /**
     * 货币下拉
     *
     * @return
     */
    @GetMapping(value = "/searchAll")
    List<ComCurrRespVO> searchAll();

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComCurrRespVO> search(@RequestBody ComCurrQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param code code
     * @return 对象
     */
    @GetMapping(value = "/getCodeOne")
    ComCurrRespVO getCodeOne(@RequestParam(value = "code") @NotBlank(message = "编码为空") String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    @GetMapping(value = "/getIdOne")
    ComCurrRespVO getIdOne(@RequestParam(value = "id") @NotBlank(message = "ID为空") Long id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/findIdBatch")
    List<ComCurrRespVO> findIdBatch(@RequestBody List<Long> idList);

    /**
     * 获取币种信息列表，该接口一般应用与如下场景
     * 1. 第三方通过code获取一些基本信息，用于后端组装数据
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping(value = "/findRpcDtoByParam")
    List<ComCurrRpcDTO> findRpcDtoByParam(@RequestBody ComCurrRpcDtoParam param);
}
