package com.elitescloud.cloudt.system.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 发号参数
 *
 * @author Michael Li
 * @date 2020-10-29
 */
@ApiModel("请求发号器生成号码的结构体")
@Data
public class SysNumberReqParam implements Serializable {

    private static final long serialVersionUID = -3337116240783054042L;

    /**
     * 发号规则ID
     */
    @ApiModelProperty("发号规则ID")
    @NotNull(message = "发号规则ID为空")
    private Long ruleId;

    /**
     * 配置选择的值
     */
    @ApiModelProperty("配置选择的值，包括生成号码时的UDC值，以及其他运行时设置的值")
    private List<String> runtimeValue;
}
