package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysRolePermissionVO;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <pre>
 *     角色权限关联服务
 * </pre>
 *
 * @author Michael Li
 * @date 2020-09-28
 */
@FeignClient(name = Application.NAME, path = SysRolePermissionService.URI)
@Validated
public interface SysRolePermissionService {
    String URI = Application.URI_PREFIX + "/rolePermission";

    @GetMapping(value = "/listPermissionsByRoleId")
    Set<SysPermissionVO> listPermissionsByRoleId(@RequestParam(value = "roleId") @NotNull(message = "角色ID为空") Long roleId);

    @GetMapping(value = "/listMenusByRoleId")
    Set<SysPermissionVO> listMenusByRoleId(@RequestParam(value = "roleId") @NotNull(message = "角色ID为空") Long roleId);

    @GetMapping(value = "/listActionsByRoleId")
    Set<SysPermissionVO> listActionsByRoleId(@RequestParam(value = "roleId") @NotNull(message = "角色ID为空") Long roleId);

    @PostMapping(value = "/listPermissionsByRoleIds")
    Map<Long, Set<SysPermissionVO>> listPermissionsByRoleIds(@RequestBody List<Long> roleIds);

    @GetMapping(value = "/listRolesByPermissionId")
    Set<SysRoleVO> listRolesByPermissionId(@RequestParam(value = "permissionId") @NotNull(message = "权限ID为空") Long permissionId);

    @PostMapping(value = "/listRolesByPermissionIds")
    Map<Long, Set<SysRoleVO>> listRolesByPermissionIds(@RequestBody List<Long> permissionIds);

    @GetMapping(value = "/listActionsByMenuIdOfRole")
    Set<SysPermissionVO> listActionsByMenuIdOfRole(@RequestParam(value = "roleId") @NotNull(message = "角色ID为空") Long roleId,
                                                   @RequestParam(value = "menuId") @NotNull(message = "菜单ID为空") Long menuId);

    @PostMapping(value = "/saveAll")
    void saveAll(@RequestBody List<SysRolePermissionVO> rps);

    @PostMapping(value = "/saveAllByMenu")
    void saveAllByMenu(@RequestParam(value = "roleId") @NotNull(message = "角色ID为空") Long roleId,
                       @RequestParam(value = "menuId") @NotNull(message = "菜单ID为空") Long menuId,
                       @RequestBody Set<Long> permissionIds);

    @DeleteMapping(value = "/removePermissionsByRoleIds")
    void removePermissionsByRoleIds(@RequestBody List<Long> roleIds);

    @DeleteMapping(value = "/removeRolesByPermissionIds")
    void removeRolesByPermissionIds(@RequestBody List<Long> permissionIds);
}
