package com.elitescloud.cloudt.comm.consumer.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * 2021-06-04
 */
@Data
public class ComTaxRateRpcDTO implements Serializable {

    private static final long serialVersionUID = -4537231138755231076L;

    @ApiModelProperty("税率ID")
    private Long id;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率说明")
    private String taxRateDesc;

    @ApiModelProperty("税率值")
    private Double taxRateValue;

    @ApiModelProperty("税率索引 [UOM]COM:TAX_RATE_INDEX")
    private String taxRateIndex;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;
}
